/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.release.Promotion;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryHttpClient;
import org.jfrog.build.client.ArtifactoryUploadResponse;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.client.DeployDetails;
import org.jfrog.build.client.PreemptiveHttpClient;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.client.VersionCompatibilityType;
import org.jfrog.build.client.VersionException;
import org.jfrog.build.util.DeploymentUrlUtils;

public class ArtifactoryBuildInfoClient {
    private static final String LOCAL_REPOS_REST_URL = "/api/repositories?type=local";
    private static final String REMOTE_REPOS_REST_URL = "/api/repositories?type=remote";
    private static final String VIRTUAL_REPOS_REST_URL = "/api/repositories?type=virtual";
    private static final String BUILD_REST_URL = "/api/build";
    private static final String BUILD_BROWSE_URL = "/webapp/builds";
    private static final int CHECKSUM_DEPLOY_MIN_FILE_SIZE = 10240;
    private final Log log;
    private ArtifactoryHttpClient httpClient;
    private String artifactoryUrl;
    private ArtifactoryVersion artifactoryVersion;

    public ArtifactoryBuildInfoClient(String artifactoryUrl, Log log) {
        this(artifactoryUrl, null, null, log);
    }

    public ArtifactoryBuildInfoClient(String artifactoryUrl, String username, String password, Log log) {
        this.artifactoryUrl = StringUtils.stripEnd((String)artifactoryUrl, (String)"/");
        this.httpClient = new ArtifactoryHttpClient(this.artifactoryUrl, username, password, log);
        this.log = log;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.httpClient.setConnectionTimeout(connectionTimeout);
    }

    public void setProxyConfiguration(String host, int port) {
        this.httpClient.setProxyConfiguration(host, port, null, null);
    }

    public void setProxyConfiguration(String host, int port, String username, String password) {
        this.httpClient.setProxyConfiguration(host, port, username, password);
    }

    public void setProxyConfiguration(ProxyConfiguration proxy) {
        this.httpClient.setProxyConfiguration(proxy.host, proxy.port, proxy.username, proxy.password);
    }

    public List<String> getLocalRepositoriesKeys() throws IOException {
        return this.getRepositoriesList(LOCAL_REPOS_REST_URL);
    }

    public List<String> getLocalAndCacheRepositoriesKeys() throws IOException {
        List<String> localRepositoriesKeys = this.getLocalRepositoriesKeys();
        List<String> remoteRepositories = this.getRemoteRepositoriesKeys();
        List cacheRepositories = Lists.transform(remoteRepositories, (Function)new Function<String, String>(){

            public String apply(String repoKey) {
                return repoKey + "-cache";
            }
        });
        return Lists.newArrayList((Iterable)Iterables.concat(localRepositoriesKeys, (Iterable)cacheRepositories));
    }

    public List<String> getRemoteRepositoriesKeys() throws IOException {
        return this.getRepositoriesList(REMOTE_REPOS_REST_URL);
    }

    public List<String> getVirtualRepositoryKeys() throws IOException {
        return this.getRepositoriesList(VIRTUAL_REPOS_REST_URL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getRepositoriesList(String restUrl) throws IOException {
        ArrayList<String> repositories = new ArrayList<String>();
        PreemptiveHttpClient client = this.httpClient.getHttpClient();
        String reposUrl = this.artifactoryUrl + restUrl;
        this.log.debug("Requesting repositories list from: " + reposUrl);
        HttpGet httpget = new HttpGet(reposUrl);
        HttpResponse response = client.execute((HttpUriRequest)httpget);
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() != 200) {
            if (entity != null) {
                entity.consumeContent();
            }
            this.throwHttpIOException("Failed to obtain list of repositories:", statusLine);
        } else if (entity != null) {
            repositories = new ArrayList();
            InputStream content = entity.getContent();
            try {
                JsonParser parser = this.httpClient.createJsonParser(content);
                JsonNode result = parser.readValueAsTree();
                this.log.debug("Repositories result = " + result);
                for (JsonNode jsonNode : result) {
                    String repositoryKey = jsonNode.get("key").getTextValue();
                    repositories.add(repositoryKey);
                }
            }
            finally {
                if (content != null) {
                    content.close();
                }
            }
        }
        return repositories;
    }

    public void sendBuildInfo(String buildInfoJson) throws IOException {
        StatusLine statusLine;
        String url = this.artifactoryUrl + BUILD_REST_URL;
        HttpPut httpPut = new HttpPut(url);
        StringEntity stringEntity = new StringEntity(buildInfoJson, "UTF-8");
        stringEntity.setContentType("application/vnd.org.jfrog.artifactory+json");
        httpPut.setEntity((HttpEntity)stringEntity);
        this.log.info("Deploying build info to: " + url);
        HttpResponse response = this.httpClient.getHttpClient().execute((HttpUriRequest)httpPut);
        if (response.getEntity() != null) {
            response.getEntity().consumeContent();
        }
        if ((statusLine = response.getStatusLine()).getStatusCode() != 204) {
            this.throwHttpIOException("Failed to send build info:", statusLine);
        }
    }

    public void sendBuildInfo(Build buildInfo) throws IOException {
        try {
            this.sendBuildInfo(this.buildInfoToJsonString(buildInfo));
            this.log.info("Build successfully deployed. Browse it in Artifactory under " + this.artifactoryUrl + BUILD_BROWSE_URL + "/" + buildInfo.getName() + "/" + buildInfo.getNumber() + "/" + buildInfo.getStarted() + "/");
        }
        catch (Exception e) {
            this.log.error("Could not build the build-info object.", (Throwable)e);
            throw new IOException("Could not publish build-info: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getItemLastModified(String path) throws IOException, ParseException {
        String url = this.artifactoryUrl + "/api/storage/" + path + "?lastModified&deep=1";
        HttpGet get = new HttpGet(url);
        HttpResponse response = this.httpClient.getHttpClient().execute((HttpUriRequest)get);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                entity.consumeContent();
            }
            this.throwHttpIOException("Failed to obtain item info:", statusLine);
        } else {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                InputStream content = entity.getContent();
                try {
                    JsonParser parser = this.httpClient.createJsonParser(content);
                    JsonNode result = parser.readValueAsTree();
                    String string = result.get("lastModified").getTextValue();
                    return string;
                }
                finally {
                    if (content != null) {
                        content.close();
                    }
                    entity.consumeContent();
                }
            }
        }
        return null;
    }

    public ArtifactoryUploadResponse deployArtifact(DeployDetails details) throws IOException {
        StringBuilder deploymentPathBuilder = new StringBuilder(this.artifactoryUrl);
        deploymentPathBuilder.append("/").append(details.getTargetRepository());
        if (!details.artifactPath.startsWith("/")) {
            deploymentPathBuilder.append("/");
        }
        deploymentPathBuilder.append(details.artifactPath);
        String deploymentPath = deploymentPathBuilder.toString();
        this.log.info("Deploying artifact: " + deploymentPath);
        deploymentPath = ArtifactoryHttpClient.encodeUrl(deploymentPath);
        ArtifactoryUploadResponse response = this.uploadFile(details, deploymentPath);
        if (!this.getArtifactoryVersion().isAtLeast(new ArtifactoryVersion("2.3.2"))) {
            this.uploadChecksums(details, deploymentPath);
        }
        return response;
    }

    public ArtifactoryVersion verifyCompatibleArtifactoryVersion() throws VersionException {
        ArtifactoryVersion version;
        try {
            version = this.httpClient.getVersion();
        }
        catch (IOException e) {
            throw new VersionException("Error occurred while requesting version information: " + e.getMessage(), e, VersionCompatibilityType.NOT_FOUND);
        }
        if (version.isNotFound()) {
            throw new VersionException("There is either an incompatible or no instance of Artifactory at the provided URL.", VersionCompatibilityType.NOT_FOUND);
        }
        boolean isCompatibleArtifactory = version.isAtLeast(ArtifactoryHttpClient.MINIMAL_ARTIFACTORY_VERSION);
        if (!isCompatibleArtifactory) {
            throw new VersionException("This plugin is compatible with version " + ArtifactoryHttpClient.MINIMAL_ARTIFACTORY_VERSION + " of Artifactory and above. Please upgrade your Artifactory server!", VersionCompatibilityType.INCOMPATIBLE);
        }
        return version;
    }

    public HttpResponse stageBuild(String buildName, String buildNumber, Promotion promotion) throws IOException {
        if (StringUtils.isBlank((String)buildName)) {
            throw new IllegalArgumentException("Build name is required for promotion.");
        }
        if (StringUtils.isBlank((String)buildNumber)) {
            throw new IllegalArgumentException("Build number is required for promotion.");
        }
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append(BUILD_REST_URL).append("/promote/").append(ArtifactoryHttpClient.encodeUrl(buildName)).append("/").append(ArtifactoryHttpClient.encodeUrl(buildNumber));
        String promotionJson = this.toJsonString(promotion);
        HttpPost httpPost = new HttpPost(urlBuilder.toString());
        StringEntity stringEntity = new StringEntity(promotionJson);
        stringEntity.setContentType("application/vnd.org.jfrog.artifactory.build.PromotionRequest+json");
        httpPost.setEntity((HttpEntity)stringEntity);
        this.log.info("Promoting build " + buildName + ", #" + buildNumber);
        return this.httpClient.getHttpClient().execute((HttpUriRequest)httpPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<Map>> getUserPluginInfo() throws IOException {
        String url = this.artifactoryUrl + "/api/plugins";
        HttpGet getPlugins = new HttpGet(url);
        HttpResponse getResponse = this.httpClient.getHttpClient().execute((HttpUriRequest)getPlugins);
        StatusLine statusLine = getResponse.getStatusLine();
        HttpEntity responseEntity = getResponse.getEntity();
        if (statusLine.getStatusCode() != 200) {
            if (responseEntity != null) {
                responseEntity.consumeContent();
            }
            this.throwHttpIOException("Failed to obtain user plugin information:", statusLine);
        } else if (responseEntity != null) {
            InputStream content = responseEntity.getContent();
            try {
                JsonParser parser = this.httpClient.createJsonParser(content);
                Map map = (Map)parser.readValueAs(Map.class);
                return map;
            }
            finally {
                if (content != null) {
                    content.close();
                }
            }
        }
        return Maps.newHashMap();
    }

    public HttpResponse executeUserPlugin(String executionName, Map<String, String> requestParams) throws IOException {
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append("/api/plugins/execute/").append(executionName).append("?");
        this.appendParamsToUrl(requestParams, urlBuilder);
        HttpPost postRequest = new HttpPost(urlBuilder.toString());
        return this.httpClient.getHttpClient().execute((HttpUriRequest)postRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getStagingStrategy(String strategyName, String buildName, Map<String, String> requestParams) throws IOException {
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append("/api/plugins/build/staging/").append(ArtifactoryHttpClient.encodeUrl(strategyName)).append("?buildName=").append(ArtifactoryHttpClient.encodeUrl(buildName)).append("&");
        this.appendParamsToUrl(requestParams, urlBuilder);
        HttpGet getRequest = new HttpGet(urlBuilder.toString());
        HttpResponse response = this.httpClient.getHttpClient().execute((HttpUriRequest)getRequest);
        StatusLine statusLine = response.getStatusLine();
        HttpEntity responseEntity = response.getEntity();
        if (statusLine.getStatusCode() != 200) {
            if (responseEntity != null) {
                responseEntity.consumeContent();
            }
            this.throwHttpIOException("Failed to obtain staging strategy:", statusLine);
        } else if (responseEntity != null) {
            InputStream content = responseEntity.getContent();
            try {
                JsonParser parser = this.httpClient.createJsonParser(content);
                Map map = (Map)parser.readValueAs(Map.class);
                return map;
            }
            finally {
                if (content != null) {
                    content.close();
                }
            }
        }
        return Maps.newHashMap();
    }

    public HttpResponse executePromotionUserPlugin(String promotionName, String buildName, String buildNumber, Map<String, String> requestParams) throws IOException {
        StringBuilder urlBuilder = new StringBuilder(this.artifactoryUrl).append("/api/plugins/build/promote/").append(promotionName).append("/").append(ArtifactoryHttpClient.encodeUrl(buildName)).append("/").append(ArtifactoryHttpClient.encodeUrl(buildNumber)).append("?");
        this.appendParamsToUrl(requestParams, urlBuilder);
        HttpPost postRequest = new HttpPost(urlBuilder.toString());
        return this.httpClient.getHttpClient().execute((HttpUriRequest)postRequest);
    }

    public void shutdown() {
        if (this.httpClient != null) {
            this.httpClient.shutdown();
        }
    }

    private void appendParamsToUrl(Map<String, String> requestParams, StringBuilder urlBuilder) throws UnsupportedEncodingException {
        if (requestParams != null && !requestParams.isEmpty()) {
            urlBuilder.append("params=");
            Iterator<Map.Entry<String, String>> paramEntryIterator = requestParams.entrySet().iterator();
            String encodedPipe = ArtifactoryHttpClient.encodeUrl("|");
            while (paramEntryIterator.hasNext()) {
                Map.Entry<String, String> paramEntry = paramEntryIterator.next();
                urlBuilder.append(ArtifactoryHttpClient.encodeUrl(paramEntry.getKey()));
                String paramValue = paramEntry.getValue();
                if (StringUtils.isNotBlank((String)paramValue)) {
                    urlBuilder.append("=").append(ArtifactoryHttpClient.encodeUrl(paramValue));
                }
                if (!paramEntryIterator.hasNext()) continue;
                urlBuilder.append(encodedPipe);
            }
        }
    }

    public String buildInfoToJsonString(Build buildInfo) throws Exception {
        ArtifactoryVersion version = this.verifyCompatibleArtifactoryVersion();
        if (!version.isAtLeast(ArtifactoryHttpClient.UNKNOWN_PROPERTIES_TOLERANT_ARTIFACTORY_VERSION)) {
            buildInfo.setBuildAgent(null);
            buildInfo.setParentName(null);
            buildInfo.setParentNumber(null);
            buildInfo.setVcsRevision(null);
        }
        if (!version.isAtLeast(ArtifactoryHttpClient.NON_NUMERIC_BUILD_NUMBERS_TOLERANT_ARTIFACTORY_VERSION)) {
            String buildNumber = buildInfo.getNumber();
            this.verifyNonNumericBuildNumber(buildNumber);
            String parentBuildNumber = buildInfo.getParentNumber();
            this.verifyNonNumericBuildNumber(parentBuildNumber);
        }
        return this.toJsonString(buildInfo);
    }

    String toJsonString(Object object) throws IOException {
        JsonFactory jsonFactory = this.httpClient.createJsonFactory();
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = jsonFactory.createJsonGenerator((Writer)writer);
        jsonGenerator.useDefaultPrettyPrinter();
        jsonGenerator.writeObject(object);
        String result = writer.getBuffer().toString();
        return result;
    }

    private void verifyNonNumericBuildNumber(String buildNumber) {
        if (buildNumber != null) {
            try {
                Long.parseLong(buildNumber);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot handle build/parent build number: " + buildNumber + ". Non-numeric build numbers are supported by Artifactory version " + ArtifactoryHttpClient.NON_NUMERIC_BUILD_NUMBERS_TOLERANT_ARTIFACTORY_VERSION + " and above. Please upgrade your Artifactory or use numeric build numbers.");
            }
        }
    }

    private ArtifactoryUploadResponse uploadFile(DeployDetails details, String uploadUrl) throws IOException {
        ArtifactoryUploadResponse response = this.tryChecksumDeploy(details, uploadUrl);
        if (response != null) {
            return response;
        }
        HttpPut httpPut = this.createHttpPutMethod(details, uploadUrl);
        httpPut.addHeader("Expect", "100-continue");
        FileEntity fileEntity = new FileEntity(details.file, "binary/octet-stream");
        response = this.httpClient.upload(httpPut, (HttpEntity)fileEntity);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 201 && statusCode != 200) {
            this.throwHttpIOException("Failed to deploy file:", response.getStatusLine());
        }
        return response;
    }

    private ArtifactoryUploadResponse tryChecksumDeploy(DeployDetails details, String uploadUrl) throws UnsupportedEncodingException {
        long fileLength = details.file.length();
        if (fileLength < 10240L) {
            this.log.debug("Skipping checksum deploy of file size " + fileLength + " , falling back to regular deployment.");
            return null;
        }
        if (!this.getArtifactoryVersion().isAtLeast(new ArtifactoryVersion("2.5.1"))) {
            return null;
        }
        HttpPut httpPut = this.createHttpPutMethod(details, uploadUrl);
        httpPut.addHeader("X-Checksum-Deploy", "true");
        String fileAbsolutePath = details.file.getAbsolutePath();
        try {
            ArtifactoryUploadResponse response = this.httpClient.execute(httpPut);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 201 || statusCode == 200) {
                this.log.debug("Successfully performed checksum deploy of file " + fileAbsolutePath + " : " + details.sha1);
                return response;
            }
            this.log.debug("Failed checksum deploy of checksum '" + details.sha1 + "' with statusCode: " + statusCode);
        }
        catch (IOException e) {
            this.log.debug("Failed artifact checksum deploy of file " + fileAbsolutePath + " : " + details.sha1);
        }
        return null;
    }

    private HttpPut createHttpPutMethod(DeployDetails details, String uploadUrl) throws UnsupportedEncodingException {
        StringBuilder deploymentPathBuilder = new StringBuilder().append(uploadUrl);
        deploymentPathBuilder.append(DeploymentUrlUtils.buildMatrixParamsString(details.properties));
        HttpPut httpPut = new HttpPut(deploymentPathBuilder.toString());
        httpPut.addHeader("X-Checksum-Sha1", details.sha1);
        httpPut.addHeader("X-Checksum-Md5", details.md5);
        return httpPut;
    }

    public void uploadChecksums(DeployDetails details, String uploadUrl) throws IOException {
        String md5;
        Map<String, String> checksums = this.getChecksumMap(details);
        String fileAbsolutePath = details.file.getAbsolutePath();
        String sha1 = checksums.get("SHA1");
        if (StringUtils.isNotBlank((String)sha1)) {
            this.log.debug("Uploading SHA1 for file " + fileAbsolutePath + " : " + sha1);
            String sha1Url = uploadUrl + ".sha1" + DeploymentUrlUtils.buildMatrixParamsString(details.properties);
            HttpPut putSha1 = new HttpPut(sha1Url);
            StringEntity sha1StringEntity = new StringEntity(sha1);
            ArtifactoryUploadResponse response = this.httpClient.upload(putSha1, (HttpEntity)sha1StringEntity);
            StatusLine sha1StatusLine = response.getStatusLine();
            int sha1StatusCode = sha1StatusLine.getStatusCode();
            if (sha1StatusCode != 201 && sha1StatusCode != 200) {
                this.throwHttpIOException("Failed to deploy SHA1 checksum:", sha1StatusLine);
            }
        }
        if (StringUtils.isNotBlank((String)(md5 = checksums.get("MD5")))) {
            this.log.debug("Uploading MD5 for file " + fileAbsolutePath + " : " + md5);
            String md5Url = uploadUrl + ".md5" + DeploymentUrlUtils.buildMatrixParamsString(details.properties);
            HttpPut putMd5 = new HttpPut(md5Url);
            StringEntity md5StringEntity = new StringEntity(md5);
            ArtifactoryUploadResponse response = this.httpClient.upload(putMd5, (HttpEntity)md5StringEntity);
            StatusLine md5StatusLine = response.getStatusLine();
            int md5StatusCode = md5StatusLine.getStatusCode();
            if (md5StatusCode != 201 && md5StatusCode != 200) {
                this.throwHttpIOException("Failed to deploy MD5 checksum:", md5StatusLine);
            }
        }
    }

    private Map<String, String> getChecksumMap(DeployDetails details) throws IOException {
        HashMap checksums = Maps.newHashMap();
        ArrayList checksumTypeList = Lists.newArrayList();
        if (StringUtils.isBlank((String)details.md5)) {
            checksumTypeList.add("MD5");
        } else {
            checksums.put("MD5", details.md5);
        }
        if (StringUtils.isBlank((String)details.sha1)) {
            checksumTypeList.add("SHA1");
        } else {
            checksums.put("SHA1", details.sha1);
        }
        if (!checksumTypeList.isEmpty()) {
            try {
                checksums.putAll(FileChecksumCalculator.calculateChecksums((File)details.file, (String[])checksumTypeList.toArray(new String[checksumTypeList.size()])));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return checksums;
    }

    private void throwHttpIOException(String message, StatusLine statusLine) throws IOException {
        String errorMessage = message + " HTTP response code: " + statusLine.getStatusCode() + ". HTTP response message: " + statusLine.getReasonPhrase();
        throw new IOException(errorMessage);
    }

    private ArtifactoryVersion getArtifactoryVersion() {
        if (this.artifactoryVersion == null) {
            try {
                this.artifactoryVersion = this.httpClient.getVersion();
            }
            catch (IOException e) {
                this.artifactoryVersion = ArtifactoryVersion.NOT_FOUND;
            }
        }
        return this.artifactoryVersion;
    }
}

