/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class PreemptiveHttpClient {
    private static final String CLIENT_VERSION;
    private DefaultHttpClient httpClient;
    private BasicHttpContext localContext;

    public PreemptiveHttpClient(int timeout) {
        this(null, null, timeout);
    }

    public PreemptiveHttpClient(String userName, String password, int timeout) {
        this.httpClient = this.createHttpClient(userName, password, timeout);
    }

    public void setProxyConfiguration(String host, int port, String username, String password) {
        HttpHost proxy = new HttpHost(host, port);
        this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        if (username != null) {
            this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(username, password));
        }
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        if (this.localContext != null) {
            return this.httpClient.execute(request, (HttpContext)this.localContext);
        }
        return this.httpClient.execute(request);
    }

    private DefaultHttpClient createHttpClient(String userName, String password, int timeout) {
        boolean requestSentRetryEnabled;
        BasicHttpParams params = new BasicHttpParams();
        int timeoutMilliSeconds = timeout * 1000;
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timeoutMilliSeconds);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timeoutMilliSeconds);
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)params);
        if (userName != null && !"".equals(userName)) {
            client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(userName, password));
            this.localContext = new BasicHttpContext();
            BasicScheme basicAuth = new BasicScheme();
            this.localContext.setAttribute("preemptive-auth", (Object)basicAuth);
            client.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuth(), 0);
        }
        if (requestSentRetryEnabled = Boolean.parseBoolean(System.getProperty("requestSentRetryEnabled"))) {
            client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(3, requestSentRetryEnabled));
        }
        String userAgent = "ArtifactoryBuildClient/" + CLIENT_VERSION;
        HttpProtocolParams.setUserAgent((HttpParams)client.getParams(), (String)userAgent);
        return client;
    }

    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    public void setHttpParams(HttpParams httpParams) {
        this.httpClient.setParams(httpParams);
    }

    static {
        Properties properties = new Properties();
        InputStream is = PreemptiveHttpClient.class.getResourceAsStream("/bi.client.properties");
        if (is != null) {
            try {
                properties.load(is);
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        CLIENT_VERSION = properties.getProperty("client.version", "unknown");
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        PreemptiveAuth() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                AuthScheme authScheme = (AuthScheme)context.getAttribute("preemptive-auth");
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
                if (authScheme != null) {
                    Credentials creds = credsProvider.getCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()));
                    if (creds == null) {
                        throw new HttpException("No credentials for preemptive authentication");
                    }
                    authState.setAuthScheme(authScheme);
                    authState.setCredentials(creds);
                }
            }
        }
    }
}

