/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class Version
implements Serializable {
    public static final Version NOT_FOUND = new Version("0.0.0");
    private static final String SNAPSHOT_SUFFIX = "SNAPSHOT";
    private final String[] versionTokens;
    private final String version;

    public Version(String version) {
        if (StringUtils.isBlank((String)version)) {
            throw new IllegalArgumentException("Please provide a valid version.");
        }
        this.version = version;
        this.versionTokens = StringUtils.split((String)version, (String)".");
    }

    public boolean isNotFound() {
        return NOT_FOUND.equals(this);
    }

    public boolean isAtLeast(Version atLeast) {
        if (atLeast != null) {
            for (int tokenIndex = 0; tokenIndex < atLeast.versionTokens.length; ++tokenIndex) {
                String atLeastToken = atLeast.versionTokens[tokenIndex].trim();
                if (this.versionTokens.length < tokenIndex + 1) {
                    return false;
                }
                int comparison = this.compareTokens(this.versionTokens[tokenIndex].trim(), atLeastToken);
                if (comparison < 0) {
                    return false;
                }
                if (comparison <= 0) continue;
                return true;
            }
        }
        return true;
    }

    private int compareTokens(String toCheck, String atLeastToken) {
        int comparison;
        boolean toCheckIsBlank = StringUtils.isBlank((String)toCheck);
        boolean atLeastTokenIsBlank = StringUtils.isBlank((String)atLeastToken);
        if (toCheckIsBlank && atLeastTokenIsBlank) {
            return 0;
        }
        if (!toCheckIsBlank && atLeastTokenIsBlank) {
            return 1;
        }
        if (toCheckIsBlank) {
            return -1;
        }
        if (StringUtils.isNumeric((String)atLeastToken)) {
            return this.compareToCheckToNumericAtLeast(toCheck, atLeastToken);
        }
        if (StringUtils.isAlphanumeric((String)atLeastToken)) {
            String atLeastTokenFirstNumerals = this.getTokenFirstNumerals(atLeastToken);
            if (StringUtils.isNotBlank((String)atLeastTokenFirstNumerals)) {
                return this.compareToCheckToNumericAtLeast(toCheck, atLeastTokenFirstNumerals);
            }
            if (StringUtils.isNumeric((String)toCheck)) {
                return -1;
            }
        }
        if ((comparison = toCheck.compareTo(atLeastToken)) == 0) {
            boolean toCheckIsSnapshot = toCheck.contains(SNAPSHOT_SUFFIX);
            boolean atLeastIsSnapshot = atLeastToken.contains(SNAPSHOT_SUFFIX);
            if (toCheckIsSnapshot && !atLeastIsSnapshot) {
                return 1;
            }
            if (!toCheckIsSnapshot && atLeastIsSnapshot) {
                return -1;
            }
        }
        return comparison;
    }

    private int compareToCheckToNumericAtLeast(String toCheck, String atLeast) {
        if (StringUtils.isNumeric((String)toCheck)) {
            return this.compareNumerals(toCheck, atLeast);
        }
        if (StringUtils.isAlphanumeric((String)toCheck)) {
            return this.compareAlphaNumericToCheckToNumericAtLeast(toCheck, atLeast);
        }
        return 1;
    }

    private int compareAlphaNumericToCheckToNumericAtLeast(String toCheck, String atLeast) {
        String toCheckFirstNumerals = this.getTokenFirstNumerals(toCheck);
        if (StringUtils.isBlank((String)toCheckFirstNumerals)) {
            return 1;
        }
        return this.compareNumerals(toCheckFirstNumerals, atLeast);
    }

    private int compareNumerals(String toCheck, String atLeast) {
        return Integer.valueOf(toCheck).compareTo(Integer.valueOf(atLeast));
    }

    private String getTokenFirstNumerals(String token) {
        char[] chars = token.toCharArray();
        StringBuilder numerals = new StringBuilder();
        for (char c : chars) {
            if (!Character.isDigit(chars[0])) break;
            numerals.append(c);
        }
        return numerals.toString();
    }

    public String toString() {
        return this.version;
    }
}

