/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryUploadResponse;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.client.PreemptiveHttpClient;
import org.jfrog.build.client.PreemptiveHttpClientBuilder;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.util.URI;

public class ArtifactoryHttpClient
implements AutoCloseable {
    public static final ArtifactoryVersion UNKNOWN_PROPERTIES_TOLERANT_ARTIFACTORY_VERSION = new ArtifactoryVersion("2.2.3");
    public static final ArtifactoryVersion NON_NUMERIC_BUILD_NUMBERS_TOLERANT_ARTIFACTORY_VERSION = new ArtifactoryVersion("2.2.4");
    public static final ArtifactoryVersion STANDALONE_BUILD_RETENTION_SUPPORTED_ARTIFACTORY_VERSION = new ArtifactoryVersion("5.2.1");
    public static final ArtifactoryVersion MINIMAL_ARTIFACTORY_VERSION = new ArtifactoryVersion("2.2.3");
    public static final String VERSION_INFO_URL = "/api/system/version";
    private static final int DEFAULT_CONNECTION_TIMEOUT_SECS = 300;
    public static final int DEFAULT_CONNECTION_RETRY = 3;
    private final Log log;
    private final String artifactoryUrl;
    private final String username;
    private final String password;
    private final String accessToken;
    private int connectionTimeout = 300;
    private int connectionRetries = 3;
    private ProxyConfiguration proxyConfiguration;
    private boolean insecureTls = false;
    private PreemptiveHttpClient deployClient;

    private ArtifactoryHttpClient(String artifactoryUrl, String username, String password, String accessToken, Log log) {
        this.artifactoryUrl = org.apache.commons.lang.StringUtils.stripEnd((String)artifactoryUrl, (String)"/");
        this.username = username;
        this.password = password;
        this.accessToken = accessToken;
        this.log = log;
    }

    public ArtifactoryHttpClient(String artifactoryUrl, String username, String password, Log log) {
        this(artifactoryUrl, username, password, "", log);
    }

    public ArtifactoryHttpClient(String artifactoryUrl, String accessToken, Log log) {
        this(artifactoryUrl, "", "", accessToken, log);
    }

    public static String encodeUrl(String unescaped) {
        byte[] rawData = URLCodec.encodeUrl((BitSet)URI.allowed_query, (byte[])StringUtils.getBytesUtf8((String)unescaped));
        return StringUtils.newStringUsAscii((byte[])rawData);
    }

    public void setProxyConfiguration(String host, int port) {
        this.setProxyConfiguration(host, port, null, null);
    }

    public void setProxyConfiguration(String host, int port, String username, String password) {
        this.proxyConfiguration = new ProxyConfiguration();
        this.proxyConfiguration.host = host;
        this.proxyConfiguration.port = port;
        this.proxyConfiguration.username = username;
        this.proxyConfiguration.password = password;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setConnectionRetries(int connectionRetries) {
        this.connectionRetries = connectionRetries;
    }

    public void setInsecureTls(boolean insecureTls) {
        this.insecureTls = insecureTls;
    }

    public int getConnectionRetries() {
        return this.connectionRetries;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    @Override
    public void close() {
        if (this.deployClient != null) {
            this.deployClient.close();
        }
    }

    public PreemptiveHttpClient getHttpClient() {
        return this.getHttpClient(this.connectionTimeout);
    }

    public PreemptiveHttpClient getHttpClient(int connectionTimeout) {
        if (this.deployClient == null) {
            PreemptiveHttpClientBuilder clientBuilder = new PreemptiveHttpClientBuilder().setConnectionRetries(this.connectionRetries).setInsecureTls(this.insecureTls).setTimeout(connectionTimeout).setLog(this.log);
            if (this.proxyConfiguration != null) {
                clientBuilder.setProxyConfiguration(this.proxyConfiguration);
            }
            if (org.apache.commons.lang.StringUtils.isNotEmpty((String)this.accessToken)) {
                clientBuilder.setAccessToken(this.accessToken);
            } else {
                clientBuilder.setUserName(this.username).setPassword(this.password);
            }
            this.deployClient = clientBuilder.build();
        }
        return this.deployClient;
    }

    /*
     * Loose catch block
     */
    public ArtifactoryVersion getVersion() throws IOException {
        String versionUrl = this.artifactoryUrl + VERSION_INFO_URL;
        HttpResponse response = this.executeGetRequest(versionUrl);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 404) {
            this.consumeEntity(response);
            return ArtifactoryVersion.NOT_FOUND;
        }
        if (statusCode != 200) {
            throw new IOException(this.getMessageFromEntity(response.getEntity()));
        }
        HttpEntity httpEntity = response.getEntity();
        if (httpEntity != null) {
            try {
                try (InputStream content = httpEntity.getContent();){
                    JsonNode result = this.getJsonNode(content);
                    this.log.debug("Version result: " + result);
                    String version = result.get("version").asText();
                    JsonNode addonsNode = result.get("addons");
                    boolean hasAddons = addonsNode != null && addonsNode.iterator().hasNext();
                    ArtifactoryVersion artifactoryVersion = new ArtifactoryVersion(version, hasAddons);
                    return artifactoryVersion;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                EntityUtils.consume((HttpEntity)httpEntity);
            }
        }
        return ArtifactoryVersion.NOT_FOUND;
    }

    public JsonNode getJsonNode(InputStream content) throws IOException {
        JsonParser parser = this.createJsonParser(content);
        return (JsonNode)parser.readValueAsTree();
    }

    private HttpResponse executeGetRequest(String lastModifiedUrl) throws IOException {
        PreemptiveHttpClient client = this.getHttpClient();
        HttpGet httpGet = new HttpGet(lastModifiedUrl);
        return client.execute((HttpUriRequest)httpGet);
    }

    private void consumeEntity(HttpResponse response) throws IOException {
        HttpEntity httpEntity = response.getEntity();
        if (httpEntity != null) {
            EntityUtils.consume((HttpEntity)httpEntity);
        }
    }

    public JsonParser createJsonParser(InputStream in) throws IOException {
        JsonFactory jsonFactory = this.createJsonFactory();
        return jsonFactory.createParser(in);
    }

    public JsonParser createJsonParser(String content) throws IOException {
        JsonFactory jsonFactory = this.createJsonFactory();
        return jsonFactory.createParser(content);
    }

    public JsonFactory createJsonFactory() {
        JsonFactory jsonFactory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        jsonFactory.setCodec((ObjectCodec)mapper);
        return jsonFactory;
    }

    public ArtifactoryUploadResponse upload(HttpPut httpPut, HttpEntity fileEntity) throws IOException {
        httpPut.setEntity(fileEntity);
        return this.execute(httpPut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactoryUploadResponse execute(HttpPut httpPut) throws IOException {
        InputStream in;
        String content;
        HttpResponse response = this.getHttpClient().execute((HttpUriRequest)httpPut);
        ArtifactoryUploadResponse artifactoryResponse = null;
        if (response.getEntity() != null && response.getEntity().getContent() != null && org.apache.commons.lang.StringUtils.isNotEmpty((String)(content = IOUtils.toString((InputStream)(in = response.getEntity().getContent()), (String)"UTF-8")))) {
            try {
                JsonParser parser = this.createJsonParser(content);
                artifactoryResponse = (ArtifactoryUploadResponse)parser.readValueAs(ArtifactoryUploadResponse.class);
            }
            catch (Exception e) {
                this.log.info("Response received: \n\n" + content + "\n\n");
                this.log.error("Failed while reading the response from: " + httpPut, (Throwable)e);
            }
            finally {
                in.close();
            }
        }
        if (artifactoryResponse == null) {
            artifactoryResponse = new ArtifactoryUploadResponse();
        }
        StatusLine statusLine = response.getStatusLine();
        artifactoryResponse.setStatusLine(statusLine);
        return artifactoryResponse;
    }

    public String getMessageFromEntity(HttpEntity entity) throws IOException {
        String responseMessage = "";
        if (entity != null) {
            responseMessage = this.getResponseEntityContent(entity);
            EntityUtils.consume((HttpEntity)entity);
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)responseMessage)) {
                responseMessage = " Response message: " + responseMessage;
            }
        }
        return responseMessage;
    }

    private String getResponseEntityContent(HttpEntity responseEntity) throws IOException {
        InputStream in = responseEntity.getContent();
        if (in != null) {
            return IOUtils.toString((InputStream)in, (String)"UTF-8");
        }
        return "";
    }
}

