/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ProxyConfiguration;

public class PreemptiveHttpClient {
    private static final String CLIENT_VERSION;
    private final boolean requestSentRetryEnabled = true;
    private CloseableHttpClient httpClient;
    private HttpClientContext localContext = HttpClientContext.create();
    private BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
    private int connectionRetries;
    private Log log;

    public PreemptiveHttpClient(String userName, String password, int timeout, ProxyConfiguration proxyConfiguration, int connectionRetries) {
        HttpClientBuilder httpClientBuilder = this.createHttpClientBuilder(userName, password, timeout, connectionRetries);
        if (proxyConfiguration != null) {
            this.setProxyConfiguration(httpClientBuilder, proxyConfiguration);
        }
        this.httpClient = httpClientBuilder.build();
    }

    private void setProxyConfiguration(HttpClientBuilder httpClientBuilder, ProxyConfiguration proxyConfiguration) {
        HttpHost proxy = new HttpHost(proxyConfiguration.host, proxyConfiguration.port);
        httpClientBuilder.setProxy(proxy);
        if (proxyConfiguration.username != null) {
            this.basicCredentialsProvider.setCredentials(new AuthScope(proxyConfiguration.host, proxyConfiguration.port), (Credentials)new UsernamePasswordCredentials(proxyConfiguration.username, proxyConfiguration.password));
            this.localContext.setCredentialsProvider((CredentialsProvider)this.basicCredentialsProvider);
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(proxy, (AuthScheme)basicAuth);
            this.localContext.setAuthCache((AuthCache)authCache);
        }
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        if (this.localContext != null) {
            return this.httpClient.execute(request, (HttpContext)this.localContext);
        }
        return this.httpClient.execute(request);
    }

    private HttpClientBuilder createHttpClientBuilder(String userName, String password, int timeout, int connectionRetries) {
        this.connectionRetries = connectionRetries;
        int timeoutMilliSeconds = timeout * 1000;
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeoutMilliSeconds).setConnectTimeout(timeoutMilliSeconds).setCircularRedirectsAllowed(true).build();
        HttpClientBuilder builder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig);
        if (StringUtils.isEmpty((String)userName)) {
            userName = "anonymous";
            password = "";
        }
        this.basicCredentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(userName, password));
        this.localContext.setCredentialsProvider((CredentialsProvider)this.basicCredentialsProvider);
        builder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuth());
        int retryCount = connectionRetries < 0 ? 3 : connectionRetries;
        builder.setRetryHandler((HttpRequestRetryHandler)new PreemptiveRetryHandler(retryCount));
        builder.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new PreemptiveRetryStrategy());
        builder.setRedirectStrategy((RedirectStrategy)new PreemptiveRedirectStrategy());
        String userAgent = "ArtifactoryBuildClient/" + CLIENT_VERSION;
        builder.setUserAgent(userAgent);
        return builder;
    }

    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setLog(Log log) {
        this.log = log;
    }

    private Set<Class<? extends IOException>> getNonRetriableClasses() {
        HashSet<Class<? extends IOException>> classSet = new HashSet<Class<? extends IOException>>();
        classSet.add(SSLException.class);
        return classSet;
    }

    static {
        Properties properties = new Properties();
        InputStream is = PreemptiveHttpClient.class.getResourceAsStream("/bi.client.properties");
        if (is != null) {
            try {
                properties.load(is);
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        CLIENT_VERSION = properties.getProperty("client.version", "unknown");
    }

    private class PreemptiveRedirectStrategy
    extends DefaultRedirectStrategy {
        private Set<String> redirectableMethods = Sets.newHashSet((Object[])new String[]{"GET".toLowerCase(), "POST".toLowerCase(), "HEAD".toLowerCase(), "DELETE".toLowerCase(), "PUT".toLowerCase()});

        private PreemptiveRedirectStrategy() {
        }

        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            URI uri = this.getLocationURI(request, response, context);
            PreemptiveHttpClient.this.log.debug("Redirecting to " + uri);
            return RequestBuilder.copy((HttpRequest)request).setUri(uri).build();
        }

        protected boolean isRedirectable(String method) {
            String message = "The method " + method;
            if (this.redirectableMethods.contains(method.toLowerCase())) {
                PreemptiveHttpClient.this.log.debug(message + " can be redirected.");
                return true;
            }
            PreemptiveHttpClient.this.log.error(message + " cannot be redirected.");
            return false;
        }
    }

    private class PreemptiveRetryHandler
    extends DefaultHttpRequestRetryHandler {
        PreemptiveRetryHandler(int connectionRetries) {
            super(connectionRetries, true, (Collection)PreemptiveHttpClient.this.getNonRetriableClasses());
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            PreemptiveHttpClient.this.log.warn("Error occurred for request " + clientContext.getRequest().getRequestLine().toString() + ": " + exception.getMessage() + ".");
            if (executionCount > PreemptiveHttpClient.this.connectionRetries) {
                return false;
            }
            boolean shouldRetry = super.retryRequest(exception, executionCount, context);
            if (shouldRetry) {
                PreemptiveHttpClient.this.log.warn("Attempting retry #" + executionCount);
                return true;
            }
            return false;
        }
    }

    private class PreemptiveRetryStrategy
    implements ServiceUnavailableRetryStrategy {
        private PreemptiveRetryStrategy() {
        }

        public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
            if (response.getStatusLine().getStatusCode() > 500) {
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                PreemptiveHttpClient.this.log.warn("Error occurred for request " + clientContext.getRequest().getRequestLine().toString() + ". Received status code " + response.getStatusLine().getStatusCode() + " and message: " + response.getStatusLine().getReasonPhrase() + ".");
                if (executionCount <= PreemptiveHttpClient.this.connectionRetries) {
                    PreemptiveHttpClient.this.log.warn("Attempting retry #" + executionCount);
                    return true;
                }
            }
            return false;
        }

        public long getRetryInterval() {
            return 0L;
        }
    }

    static class PreemptiveAuth
    implements HttpRequestInterceptor {
        PreemptiveAuth() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            HttpClientContext finalContext = (HttpClientContext)context;
            AuthState authState = finalContext.getTargetAuthState();
            if (authState.getAuthScheme() == null) {
                HttpHost targetHost;
                CredentialsProvider credsProvider = finalContext.getCredentialsProvider();
                Credentials creds = credsProvider.getCredentials(new AuthScope((targetHost = finalContext.getTargetHost()).getHostName(), targetHost.getPort()));
                if (creds == null) {
                    throw new HttpException("No credentials for preemptive authentication");
                }
                BasicScheme authScheme = new BasicScheme();
                authState.update((AuthScheme)authScheme, creds);
            }
        }
    }
}

