/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.builder.DependencyBuilder;
import org.jfrog.build.api.dependency.DownloadableArtifact;
import org.jfrog.build.api.dependency.pattern.PatternType;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.util.DependenciesDownloader;

public class DependenciesDownloaderHelper {
    private DependenciesDownloader downloader;
    private Log log;

    public DependenciesDownloaderHelper(DependenciesDownloader downloader, Log log) {
        this.downloader = downloader;
        this.log = log;
    }

    public List<Dependency> downloadDependencies(Set<DownloadableArtifact> downloadableArtifacts) throws IOException {
        ArrayList dependencies = Lists.newArrayList();
        HashSet downloadedArtifacts = Sets.newHashSet();
        for (DownloadableArtifact downloadableArtifact : downloadableArtifacts) {
            Dependency dependency = this.downloadArtifact(downloadableArtifact);
            if (dependency == null) continue;
            dependencies.add(dependency);
            downloadedArtifacts.add(downloadableArtifact);
        }
        this.removeUnusedArtifactsFromLocal(downloadedArtifacts);
        return dependencies;
    }

    private void removeUnusedArtifactsFromLocal(Set<DownloadableArtifact> downloadableArtifacts) throws IOException {
        HashSet forDeletionFiles = Sets.newHashSet();
        HashSet allResolvesFiles = Sets.newHashSet();
        for (DownloadableArtifact downloadableArtifact : downloadableArtifacts) {
            String fileDestination = this.downloader.getTargetDir(downloadableArtifact.getTargetDirPath(), downloadableArtifact.getRelativeDirPath());
            allResolvesFiles.add(fileDestination);
            if (!PatternType.DELETE.equals((Object)downloadableArtifact.getPatternType())) continue;
            forDeletionFiles.add(fileDestination);
        }
        this.downloader.removeUnusedArtifactsFromLocal(allResolvesFiles, forDeletionFiles);
    }

    private Dependency downloadArtifact(DownloadableArtifact downloadableArtifact) throws IOException {
        Dependency dependencyResult = null;
        String filePath = downloadableArtifact.getFilePath();
        String matrixParams = downloadableArtifact.getMatrixParameters();
        String uri = downloadableArtifact.getRepoUrl() + '/' + filePath;
        String uriWithParams = StringUtils.isBlank((String)matrixParams) ? uri : uri + ';' + matrixParams;
        String fileDestination = this.downloader.getTargetDir(downloadableArtifact.getTargetDirPath(), downloadableArtifact.getRelativeDirPath());
        try {
            dependencyResult = this.getDependencyLocally(uriWithParams, fileDestination);
            if (dependencyResult == null) {
                this.log.info("Downloading '" + uriWithParams + "' ...");
                HttpResponse httpResponse = this.downloader.getClient().downloadArtifact(uriWithParams);
                InputStream inputStream = httpResponse.getEntity().getContent();
                Map<String, String> checksumsMap = this.downloader.saveDownloadedFile(inputStream, fileDestination);
                if (checksumsMap == null) {
                    throw new IOException("Received null checksums map");
                }
                String md5 = this.validateMd5Checksum(httpResponse, checksumsMap.get("md5"));
                String sha1 = this.validateSha1Checksum(httpResponse, checksumsMap.get("sha1"));
                this.log.info("Successfully downloaded '" + uriWithParams + "' to '" + fileDestination + "'");
                dependencyResult = new DependencyBuilder().id(filePath).md5(md5).sha1(sha1).build();
            }
        }
        catch (FileNotFoundException e) {
            if (StringUtils.isNotBlank((String)matrixParams)) {
                String skippedMessage = "Skipping download of '" + uriWithParams + "' due to matrix params mismatch.";
                this.log.debug(skippedMessage);
            }
            String warningMessage = "Error occurred while resolving published dependency: " + e.getMessage();
            this.log.warn(warningMessage);
        }
        return dependencyResult;
    }

    private Dependency getDependencyLocally(String uriWithParams, String filePath) throws IOException {
        String sha1;
        Dependency dependencyResult = null;
        HttpResponse artifactChecksums = this.downloader.getClient().getArtifactChecksums(uriWithParams);
        String md5 = this.getMD5ChecksumFromResponse(artifactChecksums);
        if (this.downloader.isFileExistsLocally(filePath, md5, sha1 = this.getSHA1ChecksumFromResponse(artifactChecksums))) {
            this.log.debug("File '" + filePath + "' already exists locally, skipping remote download.");
            dependencyResult = new DependencyBuilder().id(filePath).md5(md5).sha1(sha1).build();
        }
        return dependencyResult;
    }

    private String validateMd5Checksum(HttpResponse httpResponse, String calculatedMd5) throws IOException {
        String md5ChecksumFromResponse = this.getMD5ChecksumFromResponse(httpResponse);
        if (!StringUtils.equals((String)this.getMD5ChecksumFromResponse(httpResponse), (String)calculatedMd5)) {
            String errorMessage = "Calculated MD5 checksum is different from original, Original: '" + md5ChecksumFromResponse + "' Calculated: '" + calculatedMd5 + "'";
            throw new IOException(errorMessage);
        }
        return md5ChecksumFromResponse == null ? "" : md5ChecksumFromResponse;
    }

    private String validateSha1Checksum(HttpResponse httpResponse, String calculatedSha1) throws IOException {
        String sha1ChecksumFromResponse = this.getSHA1ChecksumFromResponse(httpResponse);
        if (!StringUtils.equals((String)sha1ChecksumFromResponse, (String)calculatedSha1)) {
            String errorMessage = "Calculated SHA-1 checksum is different from original, Original: '" + sha1ChecksumFromResponse + "' Calculated: '" + calculatedSha1 + "'";
            throw new IOException(errorMessage);
        }
        return sha1ChecksumFromResponse == null ? "" : sha1ChecksumFromResponse;
    }

    private String getSHA1ChecksumFromResponse(HttpResponse artifactChecksums) {
        String sha1 = null;
        Header sha1Header = artifactChecksums.getFirstHeader("X-Checksum-Sha1");
        if (sha1Header != null) {
            sha1 = sha1Header.getValue();
        }
        return sha1;
    }

    private String getMD5ChecksumFromResponse(HttpResponse artifactChecksums) {
        String md5 = null;
        Header md5Header = artifactChecksums.getFirstHeader("X-Checksum-Md5");
        if (md5Header != null) {
            md5 = md5Header.getValue();
        }
        return md5;
    }
}

