/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@XStreamAlias(value="buildretention")
public class BuildRetention
implements Serializable {
    private int count = -1;
    private Date minimumBuildDate;
    private boolean deleteBuildArtifacts;
    private List<String> buildNumbersNotToBeDiscarded = Lists.newArrayList();

    public BuildRetention() {
    }

    public BuildRetention(boolean deleteBuildArtifacts) {
        this.deleteBuildArtifacts = deleteBuildArtifacts;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Date getMinimumBuildDate() {
        return this.minimumBuildDate;
    }

    public void setMinimumBuildDate(Date minimumBuildDate) {
        this.minimumBuildDate = minimumBuildDate;
    }

    public void setDeleteBuildArtifacts(boolean deleteBuildArtifacts) {
        this.deleteBuildArtifacts = deleteBuildArtifacts;
    }

    public boolean isDeleteBuildArtifacts() {
        return this.deleteBuildArtifacts;
    }

    public void addBuildNotToBeDiscarded(String buildNumber) {
        this.buildNumbersNotToBeDiscarded.add(buildNumber);
    }

    public void setBuildNumbersNotToBeDiscarded(List<String> buildNumbersNotToBeDiscarded) {
        this.buildNumbersNotToBeDiscarded = buildNumbersNotToBeDiscarded;
    }

    public List<String> getBuildNumbersNotToBeDiscarded() {
        return this.buildNumbersNotToBeDiscarded;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.count == -1 && this.minimumBuildDate == null;
    }
}

