/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.builder;

import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.Agent;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.BuildAgent;
import org.jfrog.build.api.BuildRetention;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.Issues;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.Vcs;
import org.jfrog.build.api.builder.BuildInfoBuilder;
import org.jfrog.build.api.release.PromotionStatus;
import org.jfrog.build.api.util.CommonUtils;

public class BuildInfoMavenBuilder
extends BuildInfoBuilder {
    public BuildInfoMavenBuilder(String name) {
        super(name);
    }

    @Override
    public Build build() {
        return super.build();
    }

    @Override
    public BuildInfoMavenBuilder version(String version) {
        super.version(version);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder name(String name) {
        super.name(name);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder number(String number) {
        super.number(number);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder agent(Agent agent) {
        super.agent(agent);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder buildAgent(BuildAgent buildAgent) {
        super.buildAgent(buildAgent);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder started(String started) {
        super.started(started);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder startedDate(Date startedDate) {
        super.startedDate(startedDate);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder durationMillis(long durationMillis) {
        super.durationMillis(durationMillis);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder principal(String principal) {
        super.principal(principal);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder artifactoryPrincipal(String artifactoryPrincipal) {
        super.artifactoryPrincipal(artifactoryPrincipal);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder artifactoryPluginVersion(String artifactoryPluginVersion) {
        super.artifactoryPluginVersion(artifactoryPluginVersion);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder url(String url) {
        super.url(url);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder parentName(String parentName) {
        super.parentName(parentName);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder parentNumber(String parentNumber) {
        super.parentNumber(parentNumber);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder vcs(List<Vcs> vcs) {
        super.vcs(vcs);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder vcsRevision(String vcsRevision) {
        super.vcsRevision(vcsRevision);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder vcsUrl(String vcsUrl) {
        super.vcsUrl(vcsUrl);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder modules(ConcurrentHashMap<String, Module> modules) {
        super.modules(modules);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder statuses(List<PromotionStatus> statuses) {
        super.statuses(statuses);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder addStatus(PromotionStatus promotionStatus) {
        super.addStatus(promotionStatus);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder buildRetention(BuildRetention buildRetention) {
        super.buildRetention(buildRetention);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder addModule(Module module) {
        super.addModule(module);
        this.mergeModule(module);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder properties(Properties properties) {
        super.properties(properties);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder addProperty(Object key, Object value) {
        super.addProperty(key, value);
        return this;
    }

    @Override
    public BuildInfoMavenBuilder issues(Issues issues) {
        super.issues(issues);
        return this;
    }

    private void mergeModule(Module moduleToMerge) {
        Module existingModule = this.modules.putIfAbsent(moduleToMerge.getId(), moduleToMerge);
        if (existingModule == null) {
            return;
        }
        this.mergeModuleArtifacts(existingModule, moduleToMerge);
        this.mergeModuleDependencies(existingModule, moduleToMerge);
    }

    private void mergeModuleArtifacts(Module existingModule, Module moduleToMerge) {
        List<Artifact> existingArtifacts = existingModule.getArtifacts();
        List<Artifact> artifactsToMerge = moduleToMerge.getArtifacts();
        if (existingArtifacts == null || existingArtifacts.isEmpty()) {
            existingModule.setArtifacts(artifactsToMerge);
            return;
        }
        if (artifactsToMerge == null || artifactsToMerge.isEmpty()) {
            return;
        }
        for (Artifact artifactToMerge : artifactsToMerge) {
            Artifact foundArtifact = this.findArtifact(existingArtifacts, artifactToMerge.getName());
            if (foundArtifact == null) {
                existingArtifacts.add(artifactToMerge);
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)foundArtifact.getMd5()) || !StringUtils.isBlank((CharSequence)foundArtifact.getSha1())) continue;
            foundArtifact.setType(artifactToMerge.getType());
            foundArtifact.setMd5(artifactToMerge.getMd5());
            foundArtifact.setSha1(artifactToMerge.getSha1());
            foundArtifact.setProperties(artifactToMerge.getProperties());
        }
    }

    private Artifact findArtifact(List<Artifact> existingArtifacts, String artifactKey) {
        return CommonUtils.getFirstSatisfying(existingArtifacts, input -> input.getName().equals(artifactKey), null);
    }

    private void mergeModuleDependencies(Module existingModule, Module moduleToMerge) {
        List<Dependency> existingDependencies = existingModule.getDependencies();
        List<Dependency> dependenciesToMerge = moduleToMerge.getDependencies();
        if (existingDependencies == null || existingDependencies.isEmpty()) {
            existingModule.setDependencies(dependenciesToMerge);
            return;
        }
        if (dependenciesToMerge == null || dependenciesToMerge.isEmpty()) {
            return;
        }
        for (Dependency dependencyToMerge : dependenciesToMerge) {
            Dependency foundDependency = this.findDependency(existingDependencies, dependencyToMerge.getId());
            if (foundDependency == null) {
                existingDependencies.add(dependencyToMerge);
                continue;
            }
            Set<String> mergedDependencies = foundDependency.getScopes();
            mergedDependencies.addAll(dependencyToMerge.getScopes());
            foundDependency.setScopes(mergedDependencies);
        }
    }

    private Dependency findDependency(List<Dependency> existingDependencies, String dependencyId) {
        return CommonUtils.getFirstSatisfying(existingDependencies, input -> input.getId().equals(dependencyId), null);
    }
}

