/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="licensecontrol")
public class LicenseControl
implements Serializable {
    private boolean runChecks = true;
    private boolean includePublishedArtifacts = false;
    private boolean autoDiscover = true;
    private String[] licenseViolationRecipients;
    private String[] scopes;

    public LicenseControl() {
    }

    public LicenseControl(boolean runChecks) {
        this.runChecks = runChecks;
    }

    public boolean isRunChecks() {
        return this.runChecks;
    }

    public boolean isIncludePublishedArtifacts() {
        return this.includePublishedArtifacts;
    }

    public void setIncludePublishedArtifacts(boolean includePublishedArtifacts) {
        this.includePublishedArtifacts = includePublishedArtifacts;
    }

    public void setRunChecks(boolean runChecks) {
        this.runChecks = runChecks;
    }

    public boolean isAutoDiscover() {
        return this.autoDiscover;
    }

    public void setAutoDiscover(boolean autoDiscover) {
        this.autoDiscover = autoDiscover;
    }

    public String[] getLicenseViolationRecipients() {
        return this.licenseViolationRecipients;
    }

    public void setLicenseViolationRecipients(String[] licenseViolationRecipients) {
        this.licenseViolationRecipients = licenseViolationRecipients;
    }

    public String[] getScopes() {
        return this.scopes;
    }

    public void setScopes(String[] scopes) {
        this.scopes = scopes;
    }

    public void setLicenseViolationsRecipientsList(String licenseViolationRecipients) {
        if (StringUtils.isNotBlank((CharSequence)licenseViolationRecipients)) {
            String[] recipients = StringUtils.split((String)licenseViolationRecipients, (String)" ");
            this.setLicenseViolationRecipients(recipients);
        }
    }

    public void setScopesList(String scopes) {
        if (StringUtils.isNotBlank((CharSequence)scopes)) {
            String[] splitScopes = StringUtils.split((String)scopes, (String)" ");
            this.setScopes(splitScopes);
        }
    }

    public String getScopesList() {
        StringBuilder builder = new StringBuilder();
        String[] scopes = this.getScopes();
        if (scopes == null || scopes.length == 0) {
            return builder.toString();
        }
        for (String scope : scopes) {
            builder.append(scope).append(" ");
        }
        return builder.toString();
    }

    public String getLicenseViolationsRecipientsList() {
        StringBuilder builder = new StringBuilder();
        String[] recipients = this.getLicenseViolationRecipients();
        if (recipients == null || recipients.length == 0) {
            return builder.toString();
        }
        for (String recipient : recipients) {
            builder.append(recipient).append(" ");
        }
        return builder.toString();
    }
}

