/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.builder;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.Agent;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.BuildAgent;
import org.jfrog.build.api.BuildRetention;
import org.jfrog.build.api.Governance;
import org.jfrog.build.api.Issues;
import org.jfrog.build.api.LicenseControl;
import org.jfrog.build.api.MatrixParameter;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.Vcs;
import org.jfrog.build.api.release.PromotionStatus;

public class BuildInfoBuilder {
    protected String version;
    protected String name;
    protected String started;
    protected long startedMillis;
    protected String number;
    protected String project;
    protected String artifactoryPluginVersion;
    protected Agent agent;
    protected BuildAgent buildAgent;
    protected long durationMillis;
    protected String principal;
    protected String artifactoryPrincipal;
    protected String url;
    protected String parentName;
    protected String parentNumber;
    protected List<Vcs> vcs = new ArrayList<Vcs>();
    protected String vcsRevision;
    protected String vcsUrl;
    protected List<MatrixParameter> runParameters;
    protected ConcurrentHashMap<String, Module> modules;
    protected List<PromotionStatus> statuses;
    protected Properties properties;
    protected LicenseControl licenseControl;
    protected BuildRetention buildRetention;
    protected Issues issues;
    protected Governance governance;

    public BuildInfoBuilder(String name) {
        this.name = name;
    }

    public Build build() {
        if (StringUtils.isBlank((CharSequence)this.name)) {
            throw new IllegalArgumentException("Build must have a name");
        }
        if (StringUtils.isBlank((CharSequence)this.number)) {
            throw new IllegalArgumentException("Build number must be set");
        }
        if (StringUtils.isBlank((CharSequence)this.started)) {
            throw new IllegalArgumentException("Build start time must be set");
        }
        Build build = new Build();
        if (StringUtils.isNotBlank((CharSequence)this.version)) {
            build.setVersion(this.version);
        }
        build.setName(this.name);
        build.setNumber(this.number);
        build.setProject(this.project);
        build.setAgent(this.agent);
        build.setBuildAgent(this.buildAgent);
        build.setStarted(this.started);
        build.setStartedMillis(this.startedMillis);
        build.setDurationMillis(this.durationMillis);
        build.setPrincipal(this.principal);
        build.setArtifactoryPrincipal(this.artifactoryPrincipal);
        build.setArtifactoryPluginVersion(this.artifactoryPluginVersion);
        build.setUrl(this.url);
        build.setParentName(this.parentName);
        build.setParentNumber(this.parentNumber);
        build.setRunParameters(this.runParameters);
        build.setModules((List<Module>)(this.modules != null ? new ArrayList<Module>(this.modules.values()) : null));
        build.setStatuses(this.statuses);
        build.setProperties(this.properties);
        build.setVcs(this.vcs);
        build.setLicenseControl(this.licenseControl);
        build.setBuildRetention(this.buildRetention);
        build.setIssues(this.issues);
        build.setGovernance(this.governance);
        return build;
    }

    public BuildInfoBuilder version(String version) {
        this.version = version;
        return this;
    }

    public BuildInfoBuilder name(String name) {
        this.name = name;
        return this;
    }

    public BuildInfoBuilder number(String number) {
        this.number = number;
        return this;
    }

    public BuildInfoBuilder agent(Agent agent) {
        this.agent = agent;
        return this;
    }

    public BuildInfoBuilder buildAgent(BuildAgent buildAgent) {
        this.buildAgent = buildAgent;
        return this;
    }

    public BuildInfoBuilder started(String started) {
        this.started = started;
        return this;
    }

    public BuildInfoBuilder startedDate(Date startedDate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        this.started = simpleDateFormat.format(startedDate);
        this.startedMillis = startedDate.getTime();
        return this;
    }

    public BuildInfoBuilder durationMillis(long durationMillis) {
        this.durationMillis = durationMillis;
        return this;
    }

    public BuildInfoBuilder principal(String principal) {
        this.principal = principal;
        return this;
    }

    public BuildInfoBuilder artifactoryPrincipal(String artifactoryPrincipal) {
        this.artifactoryPrincipal = artifactoryPrincipal;
        return this;
    }

    public BuildInfoBuilder artifactoryPluginVersion(String artifactoryPluginVersion) {
        this.artifactoryPluginVersion = artifactoryPluginVersion;
        return this;
    }

    public BuildInfoBuilder url(String url) {
        this.url = url;
        return this;
    }

    public BuildInfoBuilder parentName(String parentName) {
        this.parentName = parentName;
        return this;
    }

    public BuildInfoBuilder parentNumber(String parentNumber) {
        this.parentNumber = parentNumber;
        return this;
    }

    public BuildInfoBuilder vcs(List<Vcs> vcs) {
        this.vcs = vcs;
        return this;
    }

    public BuildInfoBuilder vcsRevision(String vcsRevision) {
        this.vcsRevision = vcsRevision;
        return this;
    }

    public BuildInfoBuilder vcsUrl(String vcsUrl) {
        this.vcsUrl = vcsUrl;
        return this;
    }

    public BuildInfoBuilder modules(ConcurrentHashMap<String, Module> modules) {
        this.modules = modules;
        return this;
    }

    public BuildInfoBuilder modules(List<Module> modules) {
        ConcurrentHashMap<String, Module> modulesMap = new ConcurrentHashMap<String, Module>();
        for (Module module : modules) {
            modulesMap.put(module.getId(), module);
        }
        this.modules = modulesMap;
        return this;
    }

    public BuildInfoBuilder statuses(List<PromotionStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    public BuildInfoBuilder addStatus(PromotionStatus promotionStatus) {
        if (this.statuses == null) {
            this.statuses = new ArrayList<PromotionStatus>();
        }
        this.statuses.add(promotionStatus);
        return this;
    }

    public BuildInfoBuilder licenseControl(LicenseControl licenseControl) {
        this.licenseControl = licenseControl;
        return this;
    }

    public BuildInfoBuilder buildRetention(BuildRetention buildRetention) {
        this.buildRetention = buildRetention;
        return this;
    }

    public BuildInfoBuilder buildRunParameters(List<MatrixParameter> runParameters) {
        this.runParameters = runParameters;
        return this;
    }

    public BuildInfoBuilder addRunParameters(MatrixParameter parameter) {
        if (this.runParameters == null) {
            this.runParameters = new ArrayList<MatrixParameter>();
        }
        this.runParameters.add(parameter);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildInfoBuilder addModule(Module module) {
        if (this.modules == null) {
            BuildInfoBuilder buildInfoBuilder = this;
            synchronized (buildInfoBuilder) {
                if (this.modules == null) {
                    this.modules = new ConcurrentHashMap();
                }
            }
        }
        this.modules.put(module.getId(), module);
        return this;
    }

    public BuildInfoBuilder properties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public BuildInfoBuilder addProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(key, value);
        return this;
    }

    public BuildInfoBuilder issues(Issues issues) {
        this.issues = issues;
        return this;
    }

    public BuildInfoBuilder governance(Governance governance) {
        this.governance = governance;
        return this;
    }

    public BuildInfoBuilder setProject(String project) {
        this.project = project;
        return this;
    }
}

