/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.util.CommonUtils;

public abstract class ZipUtils {
    private static final Set<String> SUPPORTED_EXTENSIONS = CommonUtils.newHashSet("zip", "tar", "tar.gz", "gz", "tgz");

    public static void extract(File sourceArchive, File destinationDirectory) throws IOException {
        if (sourceArchive == null || destinationDirectory == null) {
            throw new IllegalArgumentException("Supplied destinations cannot be null.");
        }
        if (!sourceArchive.isFile()) {
            throw new IllegalArgumentException("Supplied source archive must be an existing file.");
        }
        ZipUtils.extractFiles(sourceArchive, destinationDirectory.getCanonicalFile());
    }

    private static void extractFiles(File sourceArchive, File destinationDirectory) {
        ArchiveInputStream archiveInputStream = null;
        try {
            archiveInputStream = ZipUtils.createArchiveInputStream(sourceArchive);
            ZipUtils.extractFiles(archiveInputStream, destinationDirectory);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error while extracting " + sourceArchive.getPath(), ioe);
        }
        finally {
            IOUtils.closeQuietly((InputStream)archiveInputStream);
        }
    }

    private static void extractFiles(ArchiveInputStream archiveInputStream, File destinationDirectory) throws IOException {
        ArchiveEntry entry;
        while ((entry = archiveInputStream.getNextEntry()) != null) {
            String validatedEntryName = ZipUtils.validateEntryName(entry.getName());
            if (!StringUtils.isNotBlank((String)validatedEntryName)) continue;
            ZipUtils.extractFile(destinationDirectory, (InputStream)archiveInputStream, validatedEntryName, entry.getLastModifiedDate(), entry.isDirectory());
        }
    }

    private static ArchiveInputStream createArchiveInputStream(File sourceArchive) throws IOException {
        String fileName = sourceArchive.getName();
        String extension = PathUtils.getExtension(fileName);
        ZipUtils.verifySupportedExtension(extension);
        FileInputStream fis = new FileInputStream(sourceArchive);
        ArchiveInputStream archiveInputStream = ZipUtils.returnArchiveInputStream(fis, extension);
        if (archiveInputStream != null) {
            return archiveInputStream;
        }
        throw new IllegalArgumentException("Unsupported archive extension: '" + extension + "'");
    }

    private static ArchiveInputStream returnArchiveInputStream(InputStream inputStream, String archiveSuffix) throws IOException {
        if (ZipUtils.isZipFamilyArchive(archiveSuffix)) {
            return new ZipArchiveInputStream(inputStream);
        }
        if (ZipUtils.isTarArchive(archiveSuffix)) {
            return new TarArchiveInputStream(inputStream);
        }
        if (ZipUtils.isTgzFamilyArchive(archiveSuffix) || ZipUtils.isGzCompress(archiveSuffix)) {
            return new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(inputStream));
        }
        return new ZipArchiveInputStream(inputStream);
    }

    private static boolean isGzCompress(String archiveSuffix) {
        return archiveSuffix.equals("gz");
    }

    private static boolean isTarArchive(String archiveSuffix) {
        return archiveSuffix.endsWith("tar");
    }

    private static boolean isTgzFamilyArchive(String archiveSuffix) {
        return archiveSuffix.endsWith("tar.gz") || archiveSuffix.endsWith("tgz");
    }

    private static boolean isZipFamilyArchive(String archiveSuffix) {
        return archiveSuffix.endsWith("zip") || archiveSuffix.endsWith("jar") || archiveSuffix.toLowerCase().endsWith("nupkg") || archiveSuffix.endsWith("war");
    }

    private static void verifySupportedExtension(String extension) {
        if (!SUPPORTED_EXTENSIONS.contains(StringUtils.trim((String)extension))) {
            throw new IllegalArgumentException("Unsupported archive extension: '" + extension + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void extractFile(File destinationDirectory, InputStream zipInputStream, String entryName, Date entryDate, boolean isEntryDirectory) throws IOException {
        File resolvedEntryFile = new File(destinationDirectory, entryName);
        try {
            File parentFile = resolvedEntryFile.getParentFile();
            if (parentFile != null) {
                parentFile.mkdirs();
            }
            if (isEntryDirectory) {
                resolvedEntryFile.mkdirs();
            } else {
                byte[] buffer = new byte[1024];
                FileOutputStream fileOutputStream = null;
                try {
                    int length;
                    fileOutputStream = new FileOutputStream(resolvedEntryFile);
                    while ((length = zipInputStream.read(buffer)) >= 0) {
                        fileOutputStream.write(buffer, 0, length);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileOutputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fileOutputStream);
            }
            resolvedEntryFile.setLastModified(entryDate.getTime());
            return;
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("Can't extract file. ", ex);
        }
    }

    private static String validateEntryName(String entryName) {
        entryName = FilenameUtils.separatorsToUnix((String)entryName);
        entryName = PathUtils.trimLeadingSlashes(entryName);
        entryName = ZipUtils.removeDotSegments(entryName);
        return entryName;
    }

    private static String removeDotSegments(String path) {
        if (null == path) {
            return null;
        }
        LinkedList<String> outputSegments = new LinkedList<String>();
        while (path.length() > 0) {
            int slashStartSearchIndex;
            if (path.startsWith("../")) {
                path = PathUtils.trimLeadingSlashes(path.substring(3));
                continue;
            }
            if (path.startsWith("./")) {
                path = PathUtils.trimLeadingSlashes(path.substring(2));
                continue;
            }
            if (path.startsWith("/./")) {
                path = "/" + PathUtils.trimLeadingSlashes(path.substring(3));
                continue;
            }
            if ("/.".equals(path)) {
                path = "/";
                continue;
            }
            if (path.startsWith("/../")) {
                path = "/" + PathUtils.trimLeadingSlashes(path.substring(4));
                if (outputSegments.isEmpty()) continue;
                outputSegments.remove(outputSegments.size() - 1);
                continue;
            }
            if ("/..".equals(path)) {
                path = "/";
                if (outputSegments.isEmpty()) continue;
                outputSegments.remove(outputSegments.size() - 1);
                continue;
            }
            if ("..".equals(path) || ".".equals(path)) {
                path = "";
                continue;
            }
            if (path.startsWith("/")) {
                path = "/" + PathUtils.trimLeadingSlashes(path.substring(1));
                slashStartSearchIndex = 1;
            } else {
                slashStartSearchIndex = 0;
            }
            int segLength = path.indexOf(47, slashStartSearchIndex);
            if (-1 == segLength) {
                segLength = path.length();
            }
            outputSegments.add(path.substring(0, segLength));
            path = path.substring(segLength);
        }
        StringBuffer result = new StringBuffer();
        for (String segment : outputSegments) {
            result.append(segment);
        }
        return result.toString();
    }

    private static class PathUtils {
        private PathUtils() {
        }

        public static String getExtension(String path) {
            if (path == null) {
                return null;
            }
            int dotPos = path.lastIndexOf(46);
            if (dotPos < 0) {
                return null;
            }
            return path.substring(dotPos + 1);
        }

        public static String trimLeadingSlashes(CharSequence path) {
            CharSequence res = PathUtils.trimLeadingSlashChars(path);
            return res != null ? res.toString() : null;
        }

        public static CharSequence trimLeadingSlashChars(CharSequence path) {
            if (path == null) {
                return null;
            }
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.subSequence(1, path.length());
                return PathUtils.trimLeadingSlashChars(path);
            }
            return path;
        }

        public static String trimTrailingSlashes(CharSequence path) {
            CharSequence res = PathUtils.trimTrailingSlashesChars(path);
            return res != null ? res.toString() : null;
        }

        public static CharSequence trimTrailingSlashesChars(CharSequence path) {
            if (path == null) {
                return null;
            }
            if (path.length() > 0 && path.charAt(path.length() - 1) == '/') {
                path = path.subSequence(0, path.length() - 1);
                return PathUtils.trimTrailingSlashes(path);
            }
            return path;
        }
    }
}

