/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.builder;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Agent;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.BuildAgent;
import org.jfrog.build.api.BuildRetention;
import org.jfrog.build.api.BuildType;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.Governance;
import org.jfrog.build.api.Issues;
import org.jfrog.build.api.LicenseControl;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.release.PromotionStatus;

public class BuildInfoMavenBuilder {
    private String version;
    private String name;
    private String started;
    private String number;
    private BuildType type;
    private Agent agent;
    private BuildAgent buildAgent;
    private long durationMillis;
    private String principal;
    private String artifactoryPrincipal;
    private String url;
    private String parentName;
    private String parentNumber;
    private String vcsRevision;
    private String vcsUrl;
    private List<Module> modules;
    private List<PromotionStatus> statuses;
    private Properties properties;
    private LicenseControl licenseControl;
    private BuildRetention buildRetention;
    private Issues issues;
    private Governance governance;

    public BuildInfoMavenBuilder(String name) {
        this.name = name;
    }

    public Build build() {
        if (StringUtils.isBlank((String)this.name)) {
            throw new IllegalArgumentException("Build must have a name");
        }
        if (StringUtils.isBlank((String)this.number)) {
            throw new IllegalArgumentException("Build number must be set");
        }
        if (StringUtils.isBlank((String)this.started)) {
            throw new IllegalArgumentException("Build start time must be set");
        }
        Build build = new Build();
        if (StringUtils.isNotBlank((String)this.version)) {
            build.setVersion(this.version);
        }
        build.setName(this.name);
        build.setNumber(this.number);
        build.setType(this.type);
        build.setAgent(this.agent);
        build.setBuildAgent(this.buildAgent);
        build.setStarted(this.started);
        build.setDurationMillis(this.durationMillis);
        build.setPrincipal(this.principal);
        build.setArtifactoryPrincipal(this.artifactoryPrincipal);
        build.setUrl(this.url);
        build.setParentName(this.parentName);
        build.setParentNumber(this.parentNumber);
        build.setModules(this.modules);
        build.setStatuses(this.statuses);
        build.setProperties(this.properties);
        build.setVcsRevision(this.vcsRevision);
        build.setVcsUrl(this.vcsUrl);
        build.setLicenseControl(this.licenseControl);
        build.setBuildRetention(this.buildRetention);
        build.setIssues(this.issues);
        build.setGovernance(this.governance);
        return build;
    }

    public BuildInfoMavenBuilder version(String version) {
        this.version = version;
        return this;
    }

    public BuildInfoMavenBuilder name(String name) {
        this.name = name;
        return this;
    }

    public BuildInfoMavenBuilder number(String number) {
        this.number = number;
        return this;
    }

    public BuildInfoMavenBuilder type(BuildType type) {
        this.type = type;
        return this;
    }

    public BuildInfoMavenBuilder agent(Agent agent) {
        this.agent = agent;
        return this;
    }

    public BuildInfoMavenBuilder buildAgent(BuildAgent buildAgent) {
        this.buildAgent = buildAgent;
        return this;
    }

    public BuildInfoMavenBuilder started(String started) {
        this.started = started;
        return this;
    }

    public BuildInfoMavenBuilder startedDate(Date startedDate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        this.started = simpleDateFormat.format(startedDate);
        return this;
    }

    public BuildInfoMavenBuilder durationMillis(long durationMillis) {
        this.durationMillis = durationMillis;
        return this;
    }

    public BuildInfoMavenBuilder principal(String principal) {
        this.principal = principal;
        return this;
    }

    public BuildInfoMavenBuilder artifactoryPrincipal(String artifactoryPrincipal) {
        this.artifactoryPrincipal = artifactoryPrincipal;
        return this;
    }

    public BuildInfoMavenBuilder url(String url) {
        this.url = url;
        return this;
    }

    public BuildInfoMavenBuilder parentName(String parentName) {
        this.parentName = parentName;
        return this;
    }

    public BuildInfoMavenBuilder parentNumber(String parentNumber) {
        this.parentNumber = parentNumber;
        return this;
    }

    public BuildInfoMavenBuilder vcsRevision(String vcsRevision) {
        this.vcsRevision = vcsRevision;
        return this;
    }

    public BuildInfoMavenBuilder vcsUrl(String vcsUrl) {
        this.vcsUrl = vcsUrl;
        return this;
    }

    public BuildInfoMavenBuilder modules(List<Module> modules) {
        this.modules = modules;
        return this;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public BuildInfoMavenBuilder statuses(List<PromotionStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    public BuildInfoMavenBuilder addStatus(PromotionStatus promotionStatus) {
        if (this.statuses == null) {
            this.statuses = Lists.newArrayList();
        }
        this.statuses.add(promotionStatus);
        return this;
    }

    public BuildInfoMavenBuilder licenseControl(LicenseControl licenseControl) {
        this.licenseControl = licenseControl;
        return this;
    }

    public BuildInfoMavenBuilder buildRetention(BuildRetention buildRetention) {
        this.buildRetention = buildRetention;
        return this;
    }

    public BuildInfoMavenBuilder addModule(Module module) {
        if (this.modules == null) {
            this.modules = Lists.newArrayList();
            this.modules.add(module);
            return this;
        }
        this.mergeModule(module);
        return this;
    }

    private void mergeModule(Module moduleToMerge) {
        Module existingModule = this.findModule(moduleToMerge.getId());
        if (existingModule == null) {
            this.modules.add(moduleToMerge);
            return;
        }
        this.mergeModuleArtifacts(existingModule, moduleToMerge);
        this.mergeModuleDependencies(existingModule, moduleToMerge);
    }

    private Module findModule(final String moduleKey) {
        return (Module)Iterables.find(this.modules, (Predicate)new Predicate<Module>(){

            public boolean apply(Module input) {
                return input.getId().equals(moduleKey);
            }
        }, null);
    }

    private void mergeModuleArtifacts(Module existingModule, Module moduleToMerge) {
        List<Artifact> existingArtifacts = existingModule.getArtifacts();
        List<Artifact> artifactsToMerge = moduleToMerge.getArtifacts();
        if (existingArtifacts == null || existingArtifacts.isEmpty()) {
            existingModule.setArtifacts(artifactsToMerge);
            return;
        }
        if (artifactsToMerge == null || artifactsToMerge.isEmpty()) {
            return;
        }
        for (Artifact artifactToMerge : artifactsToMerge) {
            Artifact foundArtifact = this.findArtifact(existingArtifacts, artifactToMerge.getName());
            if (foundArtifact == null) {
                existingArtifacts.add(artifactToMerge);
                continue;
            }
            if (!StringUtils.isBlank((String)foundArtifact.getMd5()) || !StringUtils.isBlank((String)foundArtifact.getSha1())) continue;
            foundArtifact.setType(artifactToMerge.getType());
            foundArtifact.setMd5(artifactToMerge.getMd5());
            foundArtifact.setSha1(artifactToMerge.getSha1());
            foundArtifact.setProperties(artifactToMerge.getProperties());
        }
    }

    private Artifact findArtifact(List<Artifact> existingArtifacts, final String artifactKey) {
        return (Artifact)Iterables.find(existingArtifacts, (Predicate)new Predicate<Artifact>(){

            public boolean apply(Artifact input) {
                return input.getName().equals(artifactKey);
            }
        }, null);
    }

    private void mergeModuleDependencies(Module existingModule, Module moduleToMerge) {
        List<Dependency> existingDependencies = existingModule.getDependencies();
        List<Dependency> dependenciesToMerge = moduleToMerge.getDependencies();
        if (existingDependencies == null || existingDependencies.isEmpty()) {
            existingModule.setDependencies(dependenciesToMerge);
            return;
        }
        if (dependenciesToMerge == null || dependenciesToMerge.isEmpty()) {
            return;
        }
        for (Dependency dependencyToMarge : dependenciesToMerge) {
            Dependency foundDependency = this.findDependency(existingDependencies, dependencyToMarge.getId());
            if (foundDependency == null) {
                existingDependencies.add(dependencyToMarge);
                continue;
            }
            List<String> existingScopes = foundDependency.getScopes();
            List<String> scopesToMerge = dependencyToMarge.getScopes();
            for (String scopeToMerge : scopesToMerge) {
                if (existingScopes.contains(scopeToMerge)) continue;
                existingScopes.add(scopeToMerge);
            }
        }
    }

    private Dependency findDependency(List<Dependency> existingDependencies, final String dependencyId) {
        return (Dependency)Iterables.find(existingDependencies, (Predicate)new Predicate<Dependency>(){

            public boolean apply(Dependency input) {
                return input.getId().equals(dependencyId);
            }
        }, null);
    }

    public BuildInfoMavenBuilder properties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public BuildInfoMavenBuilder addProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(key, value);
        return this;
    }

    public BuildInfoMavenBuilder issues(Issues issues) {
        this.issues = issues;
        return this;
    }

    public BuildInfoMavenBuilder governance(Governance governance) {
        this.governance = governance;
        return this;
    }
}

