/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.BaseBuildBean;
import org.jfrog.build.api.Dependency;

@XStreamAlias(value="module")
public class Module
extends BaseBuildBean {
    private String id;
    @XStreamAlias(value="artifacts")
    private List<Artifact> artifacts;
    @XStreamAlias(value="excludedArtifacts")
    private List<Artifact> excludedArtifacts;
    @XStreamAlias(value="dependencies")
    private List<Dependency> dependencies;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public List<Artifact> getExcludedArtifacts() {
        return this.excludedArtifacts;
    }

    public void setArtifacts(List<Artifact> artifacts) {
        this.artifacts = artifacts;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public void setExcludedArtifacts(List<Artifact> excludedArtifacts) {
        this.excludedArtifacts = excludedArtifacts;
    }

    public void append(Module other) {
        this.artifacts = this.appendBuildFileLists(this.artifacts, other.getArtifacts());
        this.excludedArtifacts = this.appendBuildFileLists(this.excludedArtifacts, other.getExcludedArtifacts());
        this.dependencies = this.appendBuildFileLists(this.dependencies, other.getDependencies());
    }

    private <T extends BaseBuildBean> List<T> appendBuildFileLists(List<T> a, List<T> b) {
        if (a == null && b == null) {
            return null;
        }
        return Stream.of(Optional.ofNullable(a).orElseGet(Collections::emptyList), Optional.ofNullable(b).orElseGet(Collections::emptyList)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Module module = (Module)o;
        if (this.getId() != null ? !this.getId().equals(module.getId()) : module.getId() != null) {
            return false;
        }
        if (this.getArtifacts() != null ? !this.getArtifacts().equals(module.getArtifacts()) : module.getArtifacts() != null) {
            return false;
        }
        if (this.getExcludedArtifacts() != null ? !this.getExcludedArtifacts().equals(module.getExcludedArtifacts()) : module.getExcludedArtifacts() != null) {
            return false;
        }
        return this.getDependencies() != null ? this.getDependencies().equals(module.getDependencies()) : module.getDependencies() == null;
    }

    public int hashCode() {
        int result = this.getId() != null ? this.getId().hashCode() : 0;
        result = 31 * result + (this.getArtifacts() != null ? this.getArtifacts().hashCode() : 0);
        result = 31 * result + (this.getExcludedArtifacts() != null ? this.getExcludedArtifacts().hashCode() : 0);
        result = 31 * result + (this.getDependencies() != null ? this.getDependencies().hashCode() : 0);
        return result;
    }
}

