/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.builder;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Properties;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.Module;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleBuilder {
    private String id;
    private List<Artifact> artifacts;
    private List<Dependency> dependencies;
    private Properties properties;

    public Module build() {
        Module module = new Module();
        module.setId(this.id);
        module.setArtifacts(this.artifacts);
        module.setDependencies(this.dependencies);
        module.setProperties(this.properties);
        return module;
    }

    public ModuleBuilder id(String id) {
        this.id = id;
        return this;
    }

    public ModuleBuilder artifacts(List<Artifact> artifacts) {
        this.artifacts = artifacts;
        return this;
    }

    public ModuleBuilder addArtifact(Artifact artifact) {
        if (this.artifacts == null) {
            this.artifacts = Lists.newArrayList();
        }
        this.artifacts.add(artifact);
        return this;
    }

    public ModuleBuilder dependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public ModuleBuilder addDependency(Dependency dependency) {
        if (this.dependencies == null) {
            this.dependencies = Lists.newArrayList();
        }
        this.dependencies.add(dependency);
        return this;
    }

    public ModuleBuilder properties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public ModuleBuilder addProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(key, value);
        return this;
    }
}

