/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.rest.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jfrog.access.model.Realm;
import org.jfrog.access.model.UserStatus;
import org.jfrog.access.rest.LongFromDateDeserializer;
import org.jfrog.access.rest.LongToDateSerializer;
import org.jfrog.access.rest.user.UserBase;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
public abstract class UserResponseBase<T extends UserResponseBase>
implements UserBase {
    @JsonProperty
    private String username;
    @JsonProperty
    private String email;
    @JsonProperty
    private String firstName;
    @JsonProperty
    private String lastName;
    @JsonProperty
    private Realm realm;
    @JsonProperty
    private UserStatus status;
    @JsonProperty
    private List<String> allowedIps;
    @JsonProperty
    private String passwordHash;
    @JsonProperty
    @JsonSerialize(using=LongToDateSerializer.class)
    @JsonDeserialize(using=LongFromDateDeserializer.class)
    private long created;
    @JsonProperty
    @JsonSerialize(using=LongToDateSerializer.class)
    @JsonDeserialize(using=LongFromDateDeserializer.class)
    private long modified;
    @JsonProperty
    @JsonSerialize(using=LongToDateSerializer.class)
    @JsonDeserialize(using=LongFromDateDeserializer.class)
    private long lastLoginTime;
    @JsonProperty
    private String lastLoginIp;
    @JsonProperty
    private Map<String, String> customData;
    @JsonProperty
    private boolean passwordExpired;
    @JsonProperty
    private long passwordLastModified;

    public UserResponseBase() {
    }

    public UserResponseBase(String username) {
        this.username = username;
    }

    @Override
    @Nonnull
    public String getUsername() {
        return this.username;
    }

    public T username(String username) {
        this.username = username;
        return (T)this;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public T email(String email) {
        this.email = email;
        return (T)this;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    public T firstName(String firstName) {
        this.firstName = firstName;
        return (T)this;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    public T lastName(String lastName) {
        this.lastName = lastName;
        return (T)this;
    }

    @Override
    public Realm getRealm() {
        return this.realm;
    }

    public T realm(Realm realm) {
        this.realm = realm;
        return (T)this;
    }

    @Override
    @Nonnull
    public UserStatus getStatus() {
        return this.status;
    }

    public T status(UserStatus status) {
        this.status = status;
        return (T)this;
    }

    @Override
    @Nonnull
    public List<String> getAllowedIps() {
        return this.allowedIps;
    }

    public T allowedIps(@Nonnull List<String> allowedIps) {
        this.allowedIps = allowedIps;
        return (T)this;
    }

    public T allowedIp(String allowedIp) {
        if (this.allowedIps == null) {
            this.allowedIps = Lists.newArrayList();
        }
        this.allowedIps.add(allowedIp);
        return (T)this;
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    public T created(long created) {
        this.created = created;
        return (T)this;
    }

    @Override
    public long getModified() {
        return this.modified;
    }

    public T modified(long modified) {
        this.modified = modified;
        return (T)this;
    }

    @Override
    public long getLastLoginTime() {
        return this.lastLoginTime;
    }

    public T lastLoginTime(long lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
        return (T)this;
    }

    @Override
    public boolean isPasswordExpired() {
        return this.passwordExpired;
    }

    public T passwordExpired(boolean passwordExpired) {
        this.passwordExpired = passwordExpired;
        return (T)this;
    }

    @Override
    public long getPasswordLastModified() {
        return this.passwordLastModified;
    }

    public T passwordLastModified(long passwordLastModified) {
        this.passwordLastModified = passwordLastModified;
        return (T)this;
    }

    @Override
    public String getPasswordHash() {
        return this.passwordHash;
    }

    public T passwordHash(String passwordHash) {
        this.passwordHash = passwordHash;
        return (T)this;
    }

    @Override
    public String getLastLoginIp() {
        return this.lastLoginIp;
    }

    public T lastLoginIp(String lastLoginIp) {
        this.lastLoginIp = lastLoginIp;
        return (T)this;
    }

    @Override
    @Nonnull
    public Map<String, String> getCustomData() {
        return Collections.unmodifiableMap(this.customData);
    }

    @Override
    @Nullable
    public String getCustomData(String key) {
        if (this.customData != null) {
            return this.customData.get(key);
        }
        return null;
    }

    @Override
    public boolean getBooleanCustomData(String key) {
        return Boolean.parseBoolean(this.getCustomData(key));
    }

    public T customData(@Nonnull Map<String, String> customData) {
        this.customData = customData;
        return (T)this;
    }

    public T addCustomData(String key, String value) {
        if (this.customData == null) {
            this.customData = Maps.newHashMap();
        }
        this.customData.put(key, value);
        return (T)this;
    }
}

