/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.rest.imports;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.util.Map;
import org.jfrog.access.model.Realm;
import org.jfrog.access.rest.user.CustomDataBuilder;
import org.jfrog.access.rest.user.CustomDatumRequest;
import org.jfrog.access.rest.user.CustomDatumRequestImpl;
import org.jfrog.common.ArgUtils;

public class ImportGroupRequest {
    @JsonProperty
    private final String name;
    @JsonProperty
    private final String description;
    @JsonProperty
    private final boolean autoJoin;
    @JsonProperty
    private final Realm realm;
    @JsonProperty
    private final String realmAttributes;
    @JsonProperty
    private final long created;
    @JsonProperty
    private final long modified;
    @JsonProperty
    private final Map<String, CustomDatumRequest> customData;

    public ImportGroupRequest(String name, String description, boolean autoJoin, Realm realm, String realmAttributes, long created, long modified, Map<String, CustomDatumRequest> customData) {
        this.name = ArgUtils.requireNonBlank((String)name, (String)"name is required");
        this.description = description;
        this.autoJoin = autoJoin;
        this.realm = realm;
        this.realmAttributes = realmAttributes;
        this.created = created;
        this.modified = modified;
        this.customData = customData;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAutoJoin() {
        return this.autoJoin;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public String getRealmAttributes() {
        return this.realmAttributes;
    }

    public long getCreated() {
        return this.created;
    }

    public long getModified() {
        return this.modified;
    }

    public Map<String, CustomDatumRequest> getCustomData() {
        return this.customData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements CustomDataBuilder {
        private String name;
        private String description;
        private boolean autoJoin;
        private Realm realm;
        private String realmAttributes;
        private long created;
        private long modified;
        private Map<String, CustomDatumRequest> customData;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder autoJoin(boolean autoJoin) {
            this.autoJoin = autoJoin;
            return this;
        }

        public Builder realm(Realm realm) {
            this.realm = realm;
            return this;
        }

        public Builder realmAttributes(String realmAttributes) {
            this.realmAttributes = realmAttributes;
            return this;
        }

        public Builder created(long created) {
            this.created = created;
            return this;
        }

        public Builder modified(long modified) {
            this.modified = modified;
            return this;
        }

        public Builder customData(Map<String, CustomDatumRequest> customData) {
            this.customData = customData;
            return this;
        }

        @Override
        public Builder addCustomData(String key, String value) {
            if (this.customData == null) {
                this.customData = Maps.newHashMap();
            }
            this.customData.put(key, new CustomDatumRequestImpl(value));
            return this;
        }

        @Override
        public Builder addCustomData(String key, String value, boolean sensitive) {
            return this.addCustomData(key, value);
        }

        public ImportGroupRequest build() {
            return new ImportGroupRequest(ArgUtils.requireNonBlank((String)this.name, (String)"name is required"), this.description, this.autoJoin, this.realm, this.realmAttributes, this.created, this.modified, this.customData);
        }
    }
}

