/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.rest.permission;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jfrog.access.rest.permission.PermissionActions;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
public class PermissionActionsResponse
implements PermissionActions {
    @JsonProperty(value="users")
    private Map<String, List<String>> userActions;
    @JsonProperty(value="groups")
    private Map<String, List<String>> groupActions;

    @Override
    public Map<String, List<String>> getUserActions() {
        return this.userActions != null ? Collections.unmodifiableMap(this.userActions) : Collections.emptyMap();
    }

    public PermissionActionsResponse addUserAction(String user, String action) {
        if (this.userActions == null) {
            this.userActions = Maps.newHashMap();
        }
        this.userActions.computeIfAbsent(user, a -> Lists.newArrayList()).add(action);
        return this;
    }

    @Override
    public Map<String, List<String>> getGroupActions() {
        return this.groupActions != null ? Collections.unmodifiableMap(this.groupActions) : Collections.emptyMap();
    }

    public PermissionActionsResponse addGroupAction(String group, String action) {
        if (this.groupActions == null) {
            this.groupActions = Maps.newHashMap();
        }
        this.groupActions.computeIfAbsent(group, a -> Lists.newArrayList()).add(action);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionActionsResponse that = (PermissionActionsResponse)o;
        return this.getUserActions().equals(that.getUserActions()) && this.getGroupActions().equals(that.getGroupActions());
    }

    public int hashCode() {
        return Objects.hash(this.getUserActions(), this.getGroupActions());
    }
}

