/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.jfrog.access.model.CustomEnum;
import org.jfrog.common.config.diff.GenerateDiffFunction;

@GenerateDiffFunction
public class UserStatus
implements CustomEnum {
    private static final List<String> PREDEFINED_STATUSES_NAMES = Arrays.asList("enabled", "disabled", "locked");
    public static final UserStatus ENABLED = new UserStatus("enabled");
    public static final UserStatus DISABLED = new UserStatus("disabled");
    public static final UserStatus LOCKED = new UserStatus("locked");
    private static final List<UserStatus> PREDEFINED_STATUSES = Arrays.asList(ENABLED, DISABLED, LOCKED);
    private static final Map<String, UserStatus> STATUSES = Collections.unmodifiableMap(PREDEFINED_STATUSES.stream().collect(Collectors.toMap(UserStatus::getName, Function.identity())));
    private final String name;

    private UserStatus(String name) {
        this.name = UserStatus.requirePredefined(name, "Unknown user status value: " + name).toLowerCase();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public static UserStatus valueOf(@Nonnull String name) {
        UserStatus status = STATUSES.get(name.toLowerCase());
        if (status == null) {
            throw new IllegalArgumentException("Unknown user status value: " + name);
        }
        return status;
    }

    public static UserStatus valueOfOrDefault(@Nonnull String name, UserStatus defaultStatus) {
        UserStatus status = STATUSES.get(name.toLowerCase());
        if (status == null) {
            return defaultStatus;
        }
        return status;
    }

    @Nonnull
    public static Collection<UserStatus> predefinedStatuses() {
        return PREDEFINED_STATUSES;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserStatus that = (UserStatus)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private static String requirePredefined(String name, String message) {
        if (!PREDEFINED_STATUSES_NAMES.contains(name)) {
            throw new IllegalArgumentException(message);
        }
        return name;
    }
}

