/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.common;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.jfrog.common.ArgUtils;
import org.jfrog.common.config.diff.GenerateDiffFunction;
import org.jfrog.security.util.ULID;

@GenerateDiffFunction
public final class ServiceId {
    public static final String DELIMITER = "@";
    public static final String ANY_IDENTIFICATION = "*";
    public static final Pattern ELEMENT_PATTERN = Pattern.compile("[a-zA-Z0-9_\\-]+");
    public static final String SERVICE_ID_REGEX = ServiceId.createServiceIdRegex(ELEMENT_PATTERN.pattern());
    public static final String ANY_INSTANCE_ID_REGEX = "(" + ELEMENT_PATTERN + "|\\*)";
    public static final String ANY_SERVICE_ID_REGEX = ServiceId.createServiceIdRegex(ELEMENT_PATTERN.pattern(), ANY_INSTANCE_ID_REGEX);
    public static final Pattern INSTANCE_ID_NODES_AND_RESOURCE_ID_PATTERN = Pattern.compile("^([a-zA-Z0-9_\\-]+)\\/nodes\\/([a-zA-Z0-9_\\-]+)$");
    private final String serviceType;
    private final String instanceId;

    public ServiceId(@Nonnull String serviceType, @Nonnull String instanceId) {
        this.serviceType = ServiceId.requireValidElement(Objects.requireNonNull(serviceType, "service type is required"));
        this.instanceId = ServiceId.requireValidElement(Objects.requireNonNull(instanceId, "instance ID is required"));
    }

    @Nonnull
    public String getFormattedName() {
        return this.serviceType + DELIMITER + this.instanceId;
    }

    @Nonnull
    public static ServiceId fromFormattedName(@Nonnull String formattedName) {
        String[] parts = formattedName.split(DELIMITER);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid formatted name: " + formattedName);
        }
        return new ServiceId(ServiceId.requireValidElement(parts[0]), ServiceId.requireValidElement(parts[1]));
    }

    public static boolean isServiceIdWithNodesAndResourceId(@Nonnull String formattedExtendedName) {
        try {
            String[] parts = formattedExtendedName.split(DELIMITER);
            if (parts.length != 2) {
                return false;
            }
            ServiceId.requireValidElement(parts[0]);
            String instanceIdWithResourceDetails = parts[1];
            Matcher matcher = INSTANCE_ID_NODES_AND_RESOURCE_ID_PATTERN.matcher(instanceIdWithResourceDetails);
            if (!matcher.find() || matcher.groupCount() != 2) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static String requireValidElement(String element) {
        return ArgUtils.requireMatches((String)element, (Pattern)ELEMENT_PATTERN, (String)("Invalid service ID element: " + element));
    }

    @Nonnull
    public static ServiceId generateUniqueId(@Nonnull String serviceType) {
        return new ServiceId(serviceType, ULID.random().toLowerCase());
    }

    public static String createServiceIdRegex(String serviceTypeRegex) {
        return ServiceId.createServiceIdRegex(serviceTypeRegex, ELEMENT_PATTERN.pattern());
    }

    public static String createServiceIdRegex(String serviceTypeRegex, String instanceIdRegex) {
        return serviceTypeRegex + DELIMITER + instanceIdRegex;
    }

    public static String serviceIdToAnyServiceId(String serviceId) {
        String[] parts = serviceId.split(DELIMITER);
        if (parts.length < 2) {
            return null;
        }
        return ServiceId.createAnyServiceId(parts[0]);
    }

    public static String createAnyServiceId(ServiceId serviceId) {
        return ServiceId.createAnyServiceId(serviceId.getServiceType());
    }

    public static String createAnyServiceId(String serviceType) {
        return serviceType + "@*";
    }

    public static ServiceId valueOf(String formattedName) {
        return ServiceId.fromFormattedName(formattedName);
    }

    public String toString() {
        return this.getFormattedName();
    }

    public static String toWildcard(String serviceId) {
        return ServiceId.createAnyServiceId(ServiceId.fromFormattedName(serviceId).getServiceType());
    }

    @Generated
    public String getServiceType() {
        return this.serviceType;
    }

    @Generated
    public String getInstanceId() {
        return this.instanceId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceId)) {
            return false;
        }
        ServiceId other = (ServiceId)o;
        String this$serviceType = this.getServiceType();
        String other$serviceType = other.getServiceType();
        if (this$serviceType == null ? other$serviceType != null : !this$serviceType.equals(other$serviceType)) {
            return false;
        }
        String this$instanceId = this.getInstanceId();
        String other$instanceId = other.getInstanceId();
        return !(this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceType = this.getServiceType();
        result = result * 59 + ($serviceType == null ? 43 : $serviceType.hashCode());
        String $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        return result;
    }
}

