/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.token;

import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jfrog.access.token.JwtToken;

public interface JwtAccessToken
extends JwtToken {
    public static final String SCOPE_TOKEN_REGEX = "[!#-\\[\\]-~ \"]+";
    public static final Pattern SCOPE_TOKEN_PATTERN = Pattern.compile("[!#-\\[\\]-~ \"]+");
    public static final String SCOPE_DELIMITER = " ";
    public static final Pattern SCOPE_PATTERN = Pattern.compile("[!#-\\[\\]-~ \"]+( [!#-\\[\\]-~ \"]+)*");

    @Nonnull
    public List<String> getAudience();

    @Nonnull
    public List<String> getScope();

    @Nullable
    public String getExtension();

    public static List<String> requireValidScopeFormat(List<String> scope) {
        if (scope == null || scope.isEmpty()) {
            throw new IllegalArgumentException("scope is required");
        }
        scope.stream().filter(token -> !SCOPE_TOKEN_PATTERN.matcher((CharSequence)token).matches()).findFirst().ifPresent(token -> {
            throw new IllegalArgumentException("Illegal scope token: " + token);
        });
        return scope;
    }
}

