/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.util;

import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public class HexUtils {
    public static String getPaddedHexKey(String str) throws DecoderException {
        return HexUtils.getPaddedHexKey(str, 32);
    }

    public static String getPaddedHexKey(String str, int minSize) throws DecoderException {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        String paddedStr = str;
        byte[] bytes = new byte[]{};
        try {
            bytes = Hex.decodeHex((char[])str.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("Tried to decode hex str \"" + str + "\"", e);
        }
        if (bytes.length < minSize) {
            byte[] tmp = new byte[Math.max(minSize, bytes.length)];
            System.arraycopy(bytes, 0, tmp, 0, bytes.length);
            Arrays.fill(tmp, bytes.length, tmp.length, (byte)bytes.length);
            paddedStr = Hex.encodeHexString((byte[])tmp);
        }
        return paddedStr;
    }
}

