/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.util;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class EnumUtils {
    private EnumUtils() {
    }

    @Nonnull
    public static <T extends Enum, V> T fromValue(T[] values, V value, Function<T, V> getValue) {
        return (T)EnumUtils.fromValue(values, value, getValue, () -> new IllegalArgumentException("Unknown value: " + value));
    }

    @Nonnull
    public static <T extends Enum, V> T fromValue(T[] values, V value, Function<T, V> getValue, Supplier<? extends RuntimeException> exceptionSupplier) {
        return (T)Stream.of(values).filter(v -> getValue.apply(v).equals(value)).findFirst().orElseThrow(exceptionSupplier);
    }

    public static <T extends Enum, V> void assertDistinctValues(T[] values, Function<T, V> getValue) {
        long distinctSignatureCount = Stream.of(values).map(getValue).distinct().count();
        if ((long)values.length != distinctSignatureCount) {
            throw new IllegalStateException("BUG: There are enum values sharing the same inner value!!");
        }
    }

    public static <T extends Enum> void assertNamingConvention(T[] values, Function<T, String> expectedName, String message) {
        Optional<String[]> namingIssue = Stream.of(values).map(v -> new String[]{v.name(), (String)expectedName.apply(v)}).filter(naming -> !naming[0].equals(naming[1])).findFirst();
        if (namingIssue.isPresent()) {
            throw new IllegalStateException("BUG: Naming convention not implemented: " + message + "\nEnum Value Name: " + namingIssue.get()[0] + ", Expected Name: " + namingIssue.get()[1]);
        }
    }

    public static <T extends Enum> void assertRuleApplies(T[] values, String ruleName, Predicate<T> rule, String message) {
        Optional<Enum> issue = Stream.of(values).filter(v -> !rule.test(v)).findFirst();
        if (issue.isPresent()) {
            throw new IllegalStateException("BUG: Rule '" + ruleName + "' failed by enum value '" + issue.get() + "': " + message);
        }
    }
}

