/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.token;

import java.security.PublicKey;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import org.jfrog.access.token.AccessToken;
import org.jfrog.access.token.JwsAccessTokenHeader;

public interface JwtAccessToken
extends AccessToken {
    public static final String SCOPE_TOKEN_REGEX = "[!#-\\[\\]-~ \"]+";
    public static final Pattern SCOPE_TOKEN_PATTERN = Pattern.compile("[!#-\\[\\]-~ \"]+");
    public static final String SCOPE_DELIMITER = " ";
    public static final Pattern SCOPE_PATTERN = Pattern.compile("[!#-\\[\\]-~ \"]+( [!#-\\[\\]-~ \"]+)*");

    @Override
    @Nullable
    public String getTokenValue();

    @Nonnull
    public String getTokenId();

    @Nonnull
    public List<String> getAudience();

    @Nonnull
    public String getIssuer();

    @Nullable
    public Long getExpiry();

    @Nonnull
    public String getSubject();

    @Nonnull
    public List<String> getScope();

    @Nullable
    public String getExtension();

    public String getCustomClaim(String var1);

    public long getIssuedAt();

    public boolean verify(PublicKey var1);

    public boolean verify(SecretKey var1);

    public boolean isSigned();

    @Nullable
    public JwsAccessTokenHeader getJwsHeader();

    public String toJsonString();

    public static List<String> requireValidScopeFormat(List<String> scope) {
        if (scope == null || scope.isEmpty()) {
            throw new IllegalArgumentException("scope is required");
        }
        scope.stream().filter(token -> !SCOPE_TOKEN_PATTERN.matcher((CharSequence)token).matches()).findFirst().ifPresent(token -> {
            throw new IllegalArgumentException("Illegal scope token: " + token);
        });
        return scope;
    }
}

