/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.client;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.jfrog.access.client.AccessAuth;
import org.jfrog.access.client.AccessAuthSwitch;

public class AccessAuthToken
extends AccessAuth {
    private final String tokenValue;

    public AccessAuthToken(@Nonnull String tokenValue) {
        this.tokenValue = Objects.requireNonNull(tokenValue, "access token value is required");
    }

    @Nonnull
    public String getTokenValue() {
        return this.tokenValue;
    }

    @Override
    public <T> T accept(@Nonnull AccessAuthSwitch<T> authSwitch) {
        return authSwitch.caseOf(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessAuthToken that = (AccessAuthToken)o;
        return this.tokenValue.equals(that.tokenValue);
    }

    public int hashCode() {
        return this.tokenValue.hashCode();
    }
}

