/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.plugin.internal.rule;

import java.util.Map;
import java.util.function.Function;
import org.jetlinks.core.trace.FluxTracer;
import org.jetlinks.core.utils.Reactors;
import org.jetlinks.plugin.core.PluginContext;
import org.jetlinks.plugin.internal.rule.RuleEnginePlugin;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.task.ExecutionContext;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;

public abstract class FunctionRuleEnginePlugin
extends RuleEnginePlugin {
    public FunctionRuleEnginePlugin(String id, PluginContext context) {
        super(id, context);
    }

    @Override
    public final Disposable start(ExecutionContext context) {
        FluxTracer tracer = this.context().monitor().tracer().traceFlux("/apply");
        return context.getInput().accept(data -> ((Flux)data.dataToMap().concatMap(map -> this.apply((RuleData)data, (Map<String, Object>)map)).concatMap(val -> {
            RuleData ruleData = context.newRuleData(data, val);
            return context.fireEvent("result", ruleData).then(context.getOutput().write(ruleData));
        }).as((Function)tracer)).onErrorResume(err -> context.onError(err, data)).then(Reactors.ALWAYS_TRUE));
    }

    protected abstract Publisher<Object> apply(RuleData var1, Map<String, Object> var2);
}

