/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import org.jetlinks.core.utils.SerializeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TypedCollectionSerializer
implements SerializeUtils.Serializer {
    private static final Logger log = LoggerFactory.getLogger(TypedCollectionSerializer.class);
    public static final int CODE = 34;

    TypedCollectionSerializer() {
    }

    @Override
    public int getCode() {
        return 34;
    }

    @Override
    public Class<?> getJavaType() {
        return Collection.class;
    }

    @Override
    public Object deserialize(ObjectInput input) {
        Collection instance;
        int size;
        byte type = input.readByte();
        if (type == -1) {
            String name = input.readUTF();
            size = input.readInt();
            Class tClass = SerializeUtils.getClass(name);
            instance = (Collection)tClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            if (type == -2) {
                return input.readObject();
            }
            size = input.readInt();
            instance = (Collection)CollectionType.VALUES[type].instance.apply(size);
        }
        if (size == 0) {
            return instance;
        }
        for (int i = 0; i < size; ++i) {
            instance.add(SerializeUtils.readObject(input));
        }
        return instance;
    }

    @Override
    public void serialize(Object value, ObjectOutput output) {
        Collection c = (Collection)value;
        Class<?> clazz = value.getClass();
        CollectionType type = CollectionType.findOrNull(clazz);
        if (type == null) {
            if (value instanceof Externalizable) {
                output.writeByte(-2);
                output.writeObject(value);
                return;
            }
            type = value instanceof SortedSet ? CollectionType.treeSet : (value instanceof Set ? CollectionType.hashSet : (value instanceof Queue ? CollectionType.linkedList : CollectionType.arrayList));
        }
        output.writeByte(type.ordinal());
        output.writeInt(c.size());
        for (Object o : c) {
            SerializeUtils.writeObject(o, output);
        }
    }

    static enum CollectionType {
        arrayList(ArrayList::new, ArrayList.class),
        arrayListC(ArrayList::new, Arrays.asList(0).getClass()),
        linkedList(ignore -> new LinkedList(), LinkedList.class),
        cpList(ignore -> new CopyOnWriteArrayList(), CopyOnWriteArrayList.class),
        vector(Vector::new, Vector.class),
        hashSet(Sets::newHashSetWithExpectedSize, HashSet.class),
        linkedHashSet(Sets::newLinkedHashSetWithExpectedSize, LinkedHashSet.class),
        concurrentHashSet(ConcurrentHashMap::newKeySet, ConcurrentHashMap.KeySetView.class),
        treeSet(ignore -> new TreeSet(), TreeSet.class),
        cpSet(ignore -> new CopyOnWriteArraySet(), CopyOnWriteArraySet.class),
        emptySet(p -> Collections.emptySet(), Collections.emptySet().getClass()),
        unmodifiableSet(Sets::newHashSetWithExpectedSize, Collections.unmodifiableSet(Collections.emptySet()).getClass()),
        guavaTransformRandomAccessList(Lists::newArrayListWithCapacity, Lists.transform(Collections.emptyList(), x -> x).getClass()),
        guavaTransformList(ignore -> new LinkedList(), Lists.transform(new LinkedList<E>(), x -> x).getClass()),
        guavaFilteredSet(Sets::newHashSetWithExpectedSize, Sets.filter(Collections.emptySet(), e -> true).getClass()),
        guavaNavigableSet(Sets::newHashSetWithExpectedSize, Sets.filter((NavigableSet)Sets.newTreeSet(), e -> true).getClass()),
        guavaSortedSet(Sets::newHashSetWithExpectedSize, Sets.filter((SortedSet)Sets.newTreeSet(), e -> true).getClass()),
        guavaFilterCollection(ArrayList::new, Collections2.filter(Collections.emptySet(), e -> true).getClass()),
        guavaTransformedCollection(ArrayList::new, Collections2.transform(Collections.emptySet(), e -> true).getClass()),
        fastJson(ignore -> new JSONArray(), JSONArray.class),
        priorityQueue(PriorityQueue::new, PriorityQueue.class),
        arrayDeque(ArrayDeque::new, ArrayDeque.class),
        concurrentLinkedQueue(ignore -> new ConcurrentLinkedQueue(), ConcurrentLinkedQueue.class);

        private final Function<Integer, Collection<Object>> instance;
        private final Class<?> clazz;
        private static final CollectionType[] VALUES;

        static CollectionType findOrNull(Class<?> clazz) {
            for (CollectionType value : VALUES) {
                if (value.clazz != clazz) continue;
                return value;
            }
            return null;
        }

        private CollectionType(Function<Integer, Collection<Object>> instance, Class<?> clazz) {
            this.instance = instance;
            this.clazz = clazz;
        }

        static {
            VALUES = CollectionType.values();
        }
    }
}

