/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import io.netty.util.concurrent.FastThreadLocal;
import java.util.function.BiConsumer;
import reactor.function.Consumer3;
import reactor.function.Consumer4;
import reactor.function.Consumer5;

public final class StringBuilderUtils {
    private static final FastThreadLocal<StringBuilder> cacheBuilder = new FastThreadLocal<StringBuilder>(){

        protected StringBuilder initialValue() {
            return new StringBuilder();
        }
    };

    private static StringBuilder takeBuilder() {
        StringBuilder sb = (StringBuilder)cacheBuilder.get();
        if (sb.length() != 0) {
            return new StringBuilder();
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, T2, T3, T4> String buildString(T data, T2 data2, T3 data3, T4 data4, Consumer5<T, T2, T3, T4, StringBuilder> builderFunction) {
        StringBuilder builder = StringBuilderUtils.takeBuilder();
        try {
            builderFunction.accept(data, data2, data3, data4, (Object)builder);
            String string = builder.toString();
            return string;
        }
        finally {
            builder.setLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, T2, T3> String buildString(T data, T2 data2, T3 data3, Consumer4<T, T2, T3, StringBuilder> builderFunction) {
        StringBuilder builder = StringBuilderUtils.takeBuilder();
        try {
            builderFunction.accept(data, data2, data3, (Object)builder);
            String string = builder.toString();
            return string;
        }
        finally {
            builder.setLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, T2> String buildString(T data, T2 data2, Consumer3<T, T2, StringBuilder> builderFunction) {
        StringBuilder builder = StringBuilderUtils.takeBuilder();
        try {
            builderFunction.accept(data, data2, (Object)builder);
            String string = builder.toString();
            return string;
        }
        finally {
            builder.setLength(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String buildString(T data, BiConsumer<T, StringBuilder> builderFunction) {
        StringBuilder builder = StringBuilderUtils.takeBuilder();
        try {
            builderFunction.accept(data, builder);
            String string = builder.toString();
            return string;
        }
        finally {
            builder.setLength(0);
        }
    }
}

