/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.dict.EnumDict;
import org.jetlinks.core.lang.SeparatedCharSequence;
import org.jetlinks.core.lang.SeparatedString;
import org.jetlinks.core.lang.SharedPathString;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.metadata.Jsonable;
import org.jetlinks.core.utils.RecyclerUtils;
import org.jetlinks.core.utils.TypedCollectionSerializer;
import org.jetlinks.core.utils.TypedMapSerializer;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

public class SerializeUtils {
    static final Serializer[] all = new Serializer[256];
    private static final Map<Class<?>, Serializer> cache = new ConcurrentHashMap();
    private static final Map<String, Class<?>> clazzCache = new ConcurrentReferenceHashMap();
    private static final Set<Class<?>> safelySerializable;

    public static void addSafelySerializable(Class<?> ... type) {
        safelySerializable.addAll(Arrays.asList(type));
    }

    public static Object convertToSafelySerializable(Object value) {
        return SerializeUtils.convertToSafelySerializable(value, false);
    }

    public static Object convertToSafelySerializable(Object value, boolean copy) {
        if (value == null || value instanceof CharSequence || value instanceof Character || value instanceof Number || value instanceof Boolean || value instanceof Date || value instanceof TemporalAccessor) {
            return value;
        }
        if (value instanceof Jsonable) {
            Map m = Maps.transformValues((Map)((Jsonable)value).toJson(), val -> SerializeUtils.convertToSafelySerializable(val, copy));
            return copy ? new HashMap(m) : m;
        }
        if (value instanceof Map) {
            Map m = Maps.transformValues((Map)((Map)value), map -> SerializeUtils.convertToSafelySerializable(map, copy));
            return copy ? new HashMap(m) : m;
        }
        if (value instanceof Collection) {
            Collection c = Collections2.transform((Collection)((Collection)value), conn -> SerializeUtils.convertToSafelySerializable(conn, copy));
            if (!copy) {
                return c;
            }
            if (value instanceof Set) {
                return new HashSet(c);
            }
            return new ArrayList(c);
        }
        if (value instanceof EnumDict) {
            return ((EnumDict)value).getWriteJSONObject();
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value instanceof ByteBuffer) {
            value = Unpooled.wrappedBuffer((ByteBuffer)((ByteBuffer)value));
        }
        if (value instanceof ByteBuf) {
            try {
                byte[] c = ByteBufUtil.getBytes((ByteBuf)((ByteBuf)value));
                return c;
            }
            finally {
                ReferenceCountUtil.safeRelease((Object)value);
            }
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            Class<?> ctype = clazz.getComponentType();
            if (ctype.isPrimitive() || safelySerializable.contains(ctype)) {
                return value;
            }
            int len = Array.getLength(value);
            Object[] val2 = new Object[len];
            for (int i = 0; i < len; ++i) {
                val2[i] = SerializeUtils.convertToSafelySerializable(Array.get(value, i), copy);
            }
            return val2;
        }
        if (clazz.getName().startsWith("java.")) {
            return true;
        }
        if (safelySerializable.contains(value.getClass())) {
            return value;
        }
        return SerializeUtils.convertToSafelySerializable(FastBeanCopier.copy((Object)value, new LinkedHashMap(), (String[])new String[0]), copy);
    }

    public static synchronized void registerSerializer(Serializer serializer) {
        if (serializer.getCode() > 255) {
            throw new IllegalArgumentException("serializer code must be less than 255");
        }
        int code = serializer.getCode() & 0xFF;
        if (all[code] != null && !Objects.equals(all[code], serializer)) {
            throw new IllegalArgumentException("serializer code [" + serializer.getCode() + "] already exists,type:" + all[code].getJavaType());
        }
        SerializeUtils.all[code] = serializer;
        if (!(serializer instanceof InternalSerializers)) {
            cache.put(serializer.getJavaType(), serializer);
        }
    }

    public static <T extends Externalizable> void registerSerializer(int code, Class<T> type, Function<ObjectInput, ? extends T> newInstance) {
        SerializeUtils.registerSerializer(new ExternalSerializer(code, type, newInstance));
    }

    public static String readNullableUTF(ObjectInput in) {
        if (in.readBoolean()) {
            return null;
        }
        return in.readUTF();
    }

    public static void writeNullableUTF(String str, ObjectOutput out) {
        if (str == null) {
            out.writeBoolean(true);
            return;
        }
        out.writeBoolean(false);
        out.writeUTF(str);
    }

    public static void writeObject(Object obj, ObjectOutput out) {
        Serializer serializer = obj == null ? InternalSerializers.NULL : SerializeUtils.lookup(obj);
        out.writeByte(serializer.getCode());
        serializer.serialize(obj, out);
    }

    public static <T> T readObjectAs(ObjectInput input) {
        return (T)SerializeUtils.readObject(input);
    }

    public static Object readObject(ObjectInput input) {
        Serializer serializer = all[input.readUnsignedByte()];
        if (serializer == null) {
            return null;
        }
        return serializer.deserialize(input);
    }

    public static Serializer lookup(Object readyToSer) {
        if (readyToSer instanceof String) {
            return InternalSerializers.STRING;
        }
        if (readyToSer instanceof Boolean) {
            return InternalSerializers.BOOLEAN;
        }
        if (readyToSer instanceof Integer) {
            return InternalSerializers.INT;
        }
        if (readyToSer instanceof Long) {
            return InternalSerializers.LONG;
        }
        if (readyToSer instanceof Double) {
            return InternalSerializers.DOUBLE;
        }
        if (readyToSer instanceof Float) {
            return InternalSerializers.FLOAT;
        }
        if (readyToSer instanceof Byte) {
            return InternalSerializers.BYTE;
        }
        if (readyToSer instanceof Short) {
            return InternalSerializers.SHORT;
        }
        if (readyToSer instanceof Message) {
            return InternalSerializers.MESSAGE;
        }
        if (readyToSer instanceof Character) {
            return InternalSerializers.CHAR;
        }
        if (readyToSer instanceof BigDecimal) {
            return InternalSerializers.BIG_DECIMAL;
        }
        if (readyToSer instanceof BigInteger) {
            return InternalSerializers.BIG_INTEGER;
        }
        if (readyToSer instanceof ConcurrentMap) {
            return InternalSerializers.C_MAP;
        }
        if (readyToSer instanceof ConcurrentHashMap.KeySetView) {
            return InternalSerializers.C_SET;
        }
        if (readyToSer instanceof Map) {
            return all[33];
        }
        if (readyToSer instanceof Collection) {
            return all[34];
        }
        if (readyToSer instanceof ByteBuf) {
            return InternalSerializers.Netty;
        }
        if (readyToSer instanceof ByteBuffer) {
            return InternalSerializers.Nio;
        }
        if (readyToSer instanceof SharedPathString) {
            return InternalSerializers.SharedPathStringSer;
        }
        if (readyToSer instanceof SeparatedCharSequence) {
            return InternalSerializers.SeparatedCharSequenceSer;
        }
        return SerializeUtils.lookup(readyToSer.getClass());
    }

    public static Serializer lookup(Class<?> javaType) {
        return cache.computeIfAbsent(javaType, t -> {
            if (t.isPrimitive()) {
                t = Primitives.wrap((Class)t);
            }
            if (t.getClassLoader() != null && t.getClassLoader() != SerializeUtils.class.getClassLoader()) {
                return InternalSerializers.JSON;
            }
            for (Serializer type : all) {
                if (type == null || type.getJavaType() != t && !type.getJavaType().isAssignableFrom((Class<?>)t)) continue;
                return type;
            }
            if (t.isArray() && !t.getComponentType().isPrimitive()) {
                return InternalSerializers.ARRAY;
            }
            return InternalSerializers.JSON;
        });
    }

    public static <K, T> Map<K, T> readMap(ObjectInput in, Function<Integer, Map<K, T>> mapBuilder) {
        int headerSize = in.readInt();
        Map<Object, T> map = mapBuilder.apply(Math.max(8, headerSize));
        for (int i = 0; i < headerSize; ++i) {
            Object key = SerializeUtils.readObject(in);
            Object value = SerializeUtils.readObject(in);
            map.put(key, value);
        }
        return map;
    }

    public static <K, T> Map<K, T> readMap(ObjectInput in, Function<Object, K> keyMapper, Function<Object, T> valueMapper, Function<Integer, Map<K, T>> mapBuilder) {
        int headerSize = in.readInt();
        Map<K, T> map = mapBuilder.apply(Math.max(8, headerSize));
        for (int i = 0; i < headerSize; ++i) {
            K key = keyMapper.apply(SerializeUtils.readObject(in));
            T value = valueMapper.apply(SerializeUtils.readObject(in));
            map.put(key, value);
        }
        return map;
    }

    public static void readKeyValue(ObjectInput in, BiConsumer<String, Object> consumer) {
        int headerSize = in.readInt();
        for (int i = 0; i < headerSize; ++i) {
            String key = String.valueOf(SerializeUtils.readObject(in));
            consumer.accept(key, SerializeUtils.readObject(in));
        }
    }

    public static void writeKeyValue(Map<?, ?> map, ObjectOutput out) {
        if (map == null) {
            out.writeInt(0);
        } else {
            out.writeInt(map.size());
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                SerializeUtils.writeObject(entry.getKey(), out);
                SerializeUtils.writeObject(entry.getValue(), out);
            }
        }
    }

    public static <T> void writeKeyValue(Collection<T> collection, Function<T, Object> keyMapper, Function<T, Object> valueMapper, ObjectOutput out) {
        if (collection == null) {
            out.writeInt(0);
        } else {
            out.writeInt(collection.size());
            for (T t : collection) {
                Object key = keyMapper.apply(t);
                Object value = valueMapper.apply(t);
                SerializeUtils.writeObject(key, out);
                SerializeUtils.writeObject(value, out);
            }
        }
    }

    private static Class<?> loadClass(String name) {
        return SerializeUtils.class.getClassLoader().loadClass(name);
    }

    static <T> Class<T> getClass(String name) {
        return clazzCache.computeIfAbsent(name, SerializeUtils::loadClass);
    }

    static {
        for (InternalSerializers value : InternalSerializers.values()) {
            SerializeUtils.registerSerializer(value);
        }
        SerializeUtils.registerSerializer(new TypedMapSerializer());
        SerializeUtils.registerSerializer(new TypedCollectionSerializer());
        cache.put(StackTraceElement.class, InternalSerializers.StackTraceElement);
        safelySerializable = ConcurrentHashMap.newKeySet();
        SerializeUtils.addSafelySerializable(DateTime.class, LocalDateTime.class, LocalDate.class);
    }

    public static interface Serializer {
        public int getCode();

        public Class<?> getJavaType();

        public Object deserialize(ObjectInput var1);

        public void serialize(Object var1, ObjectOutput var2);
    }

    static class ExternalSerializer
    implements Serializer {
        private final int code;
        private final Class<? extends Externalizable> javaType;
        private final Function<ObjectInput, ? extends Externalizable> newInstance;

        @Override
        public Object deserialize(ObjectInput input) {
            Externalizable exz = this.newInstance.apply(input);
            exz.readExternal(input);
            return exz;
        }

        @Override
        public void serialize(Object value, ObjectOutput input) {
            Externalizable exz = (Externalizable)value;
            exz.writeExternal(input);
        }

        @Override
        public int getCode() {
            return this.code;
        }

        public Class<? extends Externalizable> getJavaType() {
            return this.javaType;
        }

        public Function<ObjectInput, ? extends Externalizable> getNewInstance() {
            return this.newInstance;
        }

        public ExternalSerializer(int code, Class<? extends Externalizable> javaType, Function<ObjectInput, ? extends Externalizable> newInstance) {
            this.code = code;
            this.javaType = javaType;
            this.newInstance = newInstance;
        }
    }

    private static enum InternalSerializers implements Serializer
    {
        NULL(0, (Class)Void.class){

            @Override
            public Object read(ObjectInput in) {
                return null;
            }

            @Override
            void write(Object value, ObjectOutput input) {
            }
        }
        ,
        BOOLEAN(1, (Class)Boolean.class){

            @Override
            public Object read(ObjectInput in) {
                return in.readBoolean();
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeBoolean((Boolean)value);
            }
        }
        ,
        BYTE(2, (Class)Byte.class){

            @Override
            Object read(ObjectInput input) {
                return input.readByte();
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeByte(((Byte)value).byteValue());
            }
        }
        ,
        CHAR(3, (Class)Character.class){

            @Override
            Object read(ObjectInput input) {
                return Character.valueOf(input.readChar());
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeChar(((Character)value).charValue());
            }
        }
        ,
        SHORT(4, (Class)Short.class){

            @Override
            Object read(ObjectInput input) {
                return input.readShort();
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeShort(((Short)value).shortValue());
            }
        }
        ,
        INT(5, (Class)Integer.class){

            @Override
            Object read(ObjectInput input) {
                return input.readInt();
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeInt((Integer)value);
            }
        }
        ,
        LONG(6, (Class)Long.class){

            @Override
            Object read(ObjectInput input) {
                return input.readLong();
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeLong((Long)value);
            }
        }
        ,
        FLOAT(7, (Class)Float.class){

            @Override
            Object read(ObjectInput input) {
                return Float.valueOf(input.readFloat());
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeFloat(((Float)value).floatValue());
            }
        }
        ,
        DOUBLE(8, (Class)Double.class){

            @Override
            Object read(ObjectInput input) {
                return input.readDouble();
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeDouble((Double)value);
            }
        }
        ,
        BIG_DECIMAL(9, (Class)BigDecimal.class){
            private static final byte ZERO = 0;
            private static final byte ONE = 1;
            private static final byte SMALL_SCALE_0 = 16;
            private static final byte SMALL_SCALE_N = 17;
            private static final byte BIG_DECIMAL = 18;

            @Override
            Object read(ObjectInput input) {
                byte type = input.readByte();
                if (0 == type) {
                    return BigDecimal.ZERO;
                }
                if (1 == type) {
                    return BigDecimal.ONE;
                }
                if (16 == type) {
                    return BigDecimal.valueOf(input.readLong());
                }
                if (17 == type) {
                    int scale = input.readInt();
                    return BigDecimal.valueOf(input.readLong(), scale);
                }
                int scale = input.readInt();
                int len = input.readInt();
                byte[] bytes = new byte[len];
                input.read(bytes);
                BigInteger b = new BigInteger(bytes);
                return new BigDecimal(b, scale);
            }

            @Override
            void write(Object value, ObjectOutput input) {
                BigDecimal decimal = (BigDecimal)value;
                if (BigDecimal.ZERO.equals(decimal)) {
                    input.write(0);
                } else if (BigDecimal.ONE.equals(decimal)) {
                    input.write(1);
                } else {
                    int scale = decimal.scale();
                    BigInteger b = decimal.unscaledValue();
                    int bits = b.bitLength();
                    if (bits < 64) {
                        if (scale == 0) {
                            input.write(16);
                        } else {
                            input.write(17);
                            input.writeInt(scale);
                        }
                        input.writeLong(b.longValue());
                    } else {
                        byte[] bytes = b.toByteArray();
                        input.write(18);
                        input.writeInt(scale);
                        input.writeInt(bytes.length);
                        input.write(bytes);
                    }
                }
            }
        }
        ,
        BIG_INTEGER(10, (Class)BigInteger.class){
            private static final byte ZERO = 0;
            private static final byte ONE = 1;
            private static final byte SMALL = 16;
            private static final byte BIG_INTEGER = 18;

            @Override
            Object read(ObjectInput input) {
                byte type = input.readByte();
                if (0 == type) {
                    return BigInteger.ZERO;
                }
                if (1 == type) {
                    return BigInteger.ONE;
                }
                if (16 == type) {
                    return BigInteger.valueOf(input.readLong());
                }
                int len = input.readInt();
                byte[] bytes = new byte[len];
                input.read(bytes);
                return new BigInteger(bytes);
            }

            @Override
            void write(Object value, ObjectOutput input) {
                BigInteger b = (BigInteger)value;
                if (BigInteger.ZERO.equals(b)) {
                    input.write(0);
                } else if (BigInteger.ONE.equals(b)) {
                    input.write(1);
                } else {
                    int bits = b.bitLength();
                    if (bits < 64) {
                        input.write(16);
                        input.writeLong(b.longValue());
                    } else {
                        byte[] bytes = b.toByteArray();
                        input.write(18);
                        input.writeInt(bytes.length);
                        input.write(bytes);
                    }
                }
            }
        }
        ,
        STRING(11, (Class)String.class){

            @Override
            Object read(ObjectInput input) {
                return input.readUTF();
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeUTF(String.valueOf(value));
            }
        }
        ,
        ARRAY(12, (Class)Object[].class){

            @Override
            Object read(ObjectInput input) {
                Serializer serializer = all[input.readUnsignedByte()];
                int len = input.readInt();
                Object array = Array.newInstance(serializer.getJavaType(), len);
                for (int i = 0; i < len; ++i) {
                    Array.set(array, i, SerializeUtils.readObject(input));
                }
                return array;
            }

            @Override
            void write(Object value, ObjectOutput input) {
                Class<?> type = value.getClass().getComponentType();
                Serializer serializer = SerializeUtils.lookup(type);
                input.writeByte(serializer.getCode());
                int len = Array.getLength(value);
                input.writeInt(len);
                for (int i = 0; i < len; ++i) {
                    SerializeUtils.writeObject(Array.get(value, i), input);
                }
            }
        }
        ,
        MAP(13, (Class)Map.class){

            @Override
            Object read(ObjectInput input) {
                return SerializeUtils.readMap(input, Maps::newLinkedHashMapWithExpectedSize);
            }

            @Override
            void write(Object value, ObjectOutput input) {
                SerializeUtils.writeKeyValue((Map)value, input);
            }
        }
        ,
        OBJECT(14, (Class)Serializable.class){

            @Override
            Object read(ObjectInput input) {
                return input.readObject();
            }

            @Override
            void write(Object value, ObjectOutput input) {
                input.writeObject(value);
            }
        }
        ,
        LIST(15, (Class)List.class){

            @Override
            Object read(ObjectInput input) {
                int len = input.readInt();
                ArrayList<Object> list = new ArrayList<Object>(len);
                for (int i = 0; i < len; ++i) {
                    list.add(SerializeUtils.readObject(input));
                }
                return list;
            }

            @Override
            void write(Object value, ObjectOutput input) {
                Collection list = (Collection)value;
                int len = list.size();
                input.writeInt(len);
                for (Object o : list) {
                    SerializeUtils.writeObject(o, input);
                }
            }
        }
        ,
        SET(19, (Class)Set.class){

            @Override
            Object read(ObjectInput input) {
                int len = input.readInt();
                LinkedHashSet list = Sets.newLinkedHashSetWithExpectedSize((int)len);
                for (int i = 0; i < len; ++i) {
                    list.add(SerializeUtils.readObject(input));
                }
                return list;
            }

            @Override
            void write(Object value, ObjectOutput input) {
                Collection list = (Collection)value;
                int len = list.size();
                input.writeInt(len);
                for (Object o : list) {
                    SerializeUtils.writeObject(o, input);
                }
            }
        }
        ,
        C_SET(35, (Class)Set.class){

            @Override
            Object read(ObjectInput input) {
                int len = input.readInt();
                ConcurrentHashMap.KeySetView list = ConcurrentHashMap.newKeySet(len);
                for (int i = 0; i < len; ++i) {
                    list.add(SerializeUtils.readObject(input));
                }
                return list;
            }

            @Override
            void write(Object value, ObjectOutput input) {
                Collection list = (Collection)value;
                int len = list.size();
                input.writeInt(len);
                for (Object o : list) {
                    SerializeUtils.writeObject(o, input);
                }
            }
        }
        ,
        C_MAP(32, (Class)ConcurrentMap.class){

            @Override
            Object read(ObjectInput input) {
                return SerializeUtils.readMap(input, ConcurrentHashMap::new);
            }

            @Override
            void write(Object value, ObjectOutput input) {
                SerializeUtils.writeKeyValue((Map)value, input);
            }
        }
        ,
        Netty(17, (Class)ByteBuf.class){

            @Override
            void write(Object value, ObjectOutput output) {
                ByteBuf buf = (ByteBuf)value;
                if (!buf.isReadable()) {
                    output.writeInt(0);
                    return;
                }
                byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buf);
                ReferenceCountUtil.safeRelease((Object)buf);
                output.writeInt(bytes.length);
                output.write(bytes);
            }

            @Override
            Object read(ObjectInput input) {
                int len = input.readInt();
                if (len == 0) {
                    return Unpooled.EMPTY_BUFFER;
                }
                byte[] bytes = new byte[len];
                input.readFully(bytes);
                return Unpooled.wrappedBuffer((byte[])bytes);
            }
        }
        ,
        Nio(18, (Class)ByteBuffer.class){

            @Override
            void write(Object value, ObjectOutput output) {
                byte[] bytes;
                ByteBuffer buf = (ByteBuffer)value;
                if (buf.hasArray()) {
                    bytes = buf.array();
                } else {
                    bytes = new byte[buf.remaining()];
                    buf.get(bytes);
                }
                output.writeInt(bytes.length);
                output.write(bytes);
            }

            @Override
            Object read(ObjectInput input) {
                int len = input.readInt();
                byte[] bytes = new byte[len];
                input.readFully(bytes);
                return ByteBuffer.wrap(bytes);
            }
        }
        ,
        MESSAGE(48, (Class)Message.class){

            @Override
            void write(Object value, ObjectOutput output) {
                MessageType.writeExternal((Message)value, output);
            }

            @Override
            Object read(ObjectInput input) {
                return MessageType.readExternal(input);
            }
        }
        ,
        JSON(16, (Class)Object.class){

            @Override
            Object read(ObjectInput input) {
                String clazz = input.readUTF();
                Class tClass = SerializeUtils.getClass(clazz);
                int len = input.readInt();
                byte[] jsonByte = new byte[len];
                input.readFully(jsonByte);
                return com.alibaba.fastjson.JSON.parseObject((byte[])jsonByte, tClass, (Feature[])new Feature[0]);
            }

            @Override
            void write(Object value, ObjectOutput output) {
                Class clazz = ClassUtils.getUserClass((Object)value);
                String className = clazz.getClassLoader() != null && clazz.getClassLoader() != SerializeUtils.class.getClassLoader() ? Object.class.getName() : clazz.getName();
                output.writeUTF(className);
                byte[] jsonBytes = com.alibaba.fastjson.JSON.toJSONBytes((Object)value, (SerializerFeature[])new SerializerFeature[0]);
                output.writeInt(jsonBytes.length);
                output.write(jsonBytes);
            }
        }
        ,
        SharedPathStringSer(64, (Class)SharedPathString.class){

            @Override
            Object read(ObjectInput input) {
                int size = input.readInt();
                String[] arr = new String[size];
                for (int i = 0; i < size; ++i) {
                    arr[i] = RecyclerUtils.intern(input.readUTF());
                }
                return SharedPathString.of(arr);
            }

            @Override
            void write(Object value, ObjectOutput input) {
                SharedPathString path = (SharedPathString)value;
                input.writeInt(path.size());
                for (String str : path.unsafeSeparated()) {
                    input.writeUTF(str);
                }
            }
        }
        ,
        SeparatedCharSequenceSer(65, (Class)SeparatedCharSequence.class){

            @Override
            Object read(ObjectInput input) {
                char c = input.readChar();
                int size = input.readInt();
                String[] arr = new String[size];
                for (int i = 0; i < size; ++i) {
                    arr[i] = input.readUTF();
                }
                return SeparatedString.create(c, arr);
            }

            @Override
            void write(Object value, ObjectOutput input) {
                SeparatedCharSequence path = (SeparatedCharSequence)value;
                input.writeChar(path.separator());
                input.writeInt(path.size());
                for (CharSequence str : path) {
                    input.writeUTF(str.toString());
                }
            }
        }
        ,
        StackTraceElement(66, (Class)StackTraceElement.class){

            @Override
            Object read(ObjectInput input) {
                String className = input.readUTF();
                String methodName = input.readUTF();
                String fileName = SerializeUtils.readNullableUTF(input);
                int lineNumber = input.readInt();
                return new StackTraceElement(className, methodName, fileName, lineNumber);
            }

            @Override
            void write(Object value, ObjectOutput input) {
                StackTraceElement element = (StackTraceElement)value;
                input.writeUTF(element.getClassName());
                input.writeUTF(element.getMethodName());
                SerializeUtils.writeNullableUTF(element.getFileName(), input);
                input.writeInt(element.getLineNumber());
            }
        };

        public final int code;
        public final Class<?> javaType;

        abstract Object read(ObjectInput var1);

        abstract void write(Object var1, ObjectOutput var2);

        @Override
        public void serialize(Object value, ObjectOutput input) {
            this.write(value, input);
        }

        @Override
        public Object deserialize(ObjectInput input) {
            return this.read(input);
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public Class<?> getJavaType() {
            return this.javaType;
        }

        private InternalSerializers(int code, Class<?> javaType) {
            this.code = code;
            this.javaType = javaType;
        }
    }
}

