/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ResourceUtils;
import reactor.function.Consumer3;
import reactor.function.Function3;

public class ClassUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassUtils.class);

    public static <T, Loader extends ClassLoader> Optional<T> findImplClass(Class<T> superType, String location, Loader loader, Function3<Loader, String, InputStream, Class<?>> loadFunction) {
        boolean isJar = false;
        if (loader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                isJar = ResourceUtils.isJarURL((URL)url) || url.getFile().endsWith("jar") || url.getFile().endsWith("zip");
            }
        }
        return ClassUtils.findImplClass(superType, location, isJar, loader, loadFunction);
    }

    public static <T, Loader extends ClassLoader> Optional<T> findImplClass(Class<T> superType, String location, Loader loader, BiFunction<Loader, String, Class<?>> loadFunction) {
        return ClassUtils.findImplClass(superType, location, loader, (_loader, classname, stream) -> (Class)loadFunction.apply((Object)_loader, (String)classname));
    }

    public static <T, Loader extends ClassLoader> Optional<T> findImplClass(Class<T> superType, String location, boolean jar, Loader loader, Consumer3<Loader, String, InputStream> walker, Function3<Loader, String, InputStream, Class<?>> loadFunction) {
        return ClassUtils.createScanner(loader, location, jar).walkClass(walker).findImplClass(superType, loadFunction);
    }

    public static <T, Loader extends ClassLoader> Optional<T> findImplClass(Class<T> superType, String location, boolean jar, Loader loader, Function3<Loader, String, InputStream, Class<?>> loadFunction) {
        return ClassUtils.createScanner(loader, location, jar).findImplClass(superType, loadFunction);
    }

    public static <T, Loader extends ClassLoader> Optional<T> findImplClass(Class<T> superType, String location, boolean jar, Loader loader, BiFunction<Loader, String, Class<?>> loadFunction) {
        return ClassUtils.findImplClass(superType, location, jar, loader, (_loader, classname, stream) -> (Class)loadFunction.apply((Object)_loader, (String)classname));
    }

    public static <Loader extends ClassLoader> Scanner<Loader> createScanner(Loader loader, String location, boolean jar) {
        return new Scanner<Loader>(loader, location, jar);
    }

    public static class Scanner<Loader extends ClassLoader> {
        private final Loader loader;
        private final List<MetadataReader> classResources;

        public Scanner(Loader loader, String location, final boolean jar) {
            this.loader = loader;
            CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory();
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver((ClassLoader)loader){

                protected boolean isJarResource(@NonNull Resource resource) {
                    if (resource == null) {
                        throw new NullPointerException("resource is marked non-null but is null");
                    }
                    return jar;
                }
            };
            Resource[] classes = resourcePatternResolver.getResources(location);
            this.classResources = new ArrayList<MetadataReader>(classes.length);
            for (Resource aClass : classes) {
                this.classResources.add(metadataReaderFactory.getMetadataReader(aClass));
            }
            metadataReaderFactory.clearCache();
        }

        public Scanner<Loader> walkClass(Consumer3<Loader, String, InputStream> consumer) {
            for (MetadataReader reader : this.classResources) {
                InputStream stream = reader.getResource().getInputStream();
                Throwable throwable = null;
                try {
                    consumer.accept(this.loader, (Object)reader.getClassMetadata().getClassName(), (Object)stream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public <T> Optional<T> findImplClass(Class<T> superType, Function3<Loader, String, InputStream, Class<?>> loader) {
            Iterator<MetadataReader> iterator = this.classResources.iterator();
            while (iterator.hasNext()) {
                MetadataReader reader = iterator.next();
                AnnotationMetadata annotationMetadata = reader.getAnnotationMetadata();
                if (annotationMetadata.hasAnnotation("java.lang.Deprecated")) continue;
                ClassMetadata classMetadata = reader.getClassMetadata();
                try {
                    InputStream stream = reader.getResource().getInputStream();
                    Throwable throwable = null;
                    try {
                        Class clazz = (Class)loader.apply(this.loader, (Object)classMetadata.getClassName(), (Object)stream);
                        if (!superType.isAssignableFrom(clazz)) continue;
                        Optional optional = Optional.of(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        return optional;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    log.warn("load class [{}] error {}", new Object[]{classMetadata.getClassName(), e.getLocalizedMessage(), e});
                }
            }
            return Optional.empty();
        }
    }
}

