/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.jetlinks.core.utils.StringBuilderUtils;

public class CharsetUtils {
    public static boolean isHumanFriendly(ByteBuf byteBuf) {
        if (byteBuf == null || byteBuf.readableBytes() == 0) {
            return true;
        }
        return CharsetUtils.isHumanFriendly(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    public static boolean isHumanFriendly(ByteBuf byteBuf, int index, int length) {
        if (byteBuf == null || length <= 0) {
            return true;
        }
        if (index < 0 || index + length > byteBuf.capacity()) {
            return false;
        }
        try {
            byte[] bytes = new byte[length];
            byteBuf.getBytes(index, bytes);
            String str = new String(bytes, StandardCharsets.UTF_8);
            return CharsetUtils.isHumanFriendly(str);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isHumanFriendly(String str) {
        int codePoint;
        if (str == null || str.isEmpty()) {
            return true;
        }
        for (int i = 0; i < str.length(); i += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(i);
            if (CharsetUtils.isHumanFriendly(codePoint)) continue;
            return false;
        }
        return true;
    }

    public static boolean isHumanFriendly(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return true;
        }
        try {
            String str = new String(bytes, StandardCharsets.UTF_8);
            return CharsetUtils.isHumanFriendly(str);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isHumanFriendly(int codePoint) {
        if (!Character.isValidCodePoint(codePoint)) {
            return false;
        }
        if (CharsetUtils.isCommonWhitespace(codePoint)) {
            return true;
        }
        Character.UnicodeBlock block = Character.UnicodeBlock.of(codePoint);
        if (block == null) {
            return false;
        }
        if (CharsetUtils.isControlOrSpecialBlock(block)) {
            return false;
        }
        int type = Character.getType(codePoint);
        if (type == 18 || type == 19 || type == 0) {
            return false;
        }
        if (type == 16) {
            if (codePoint == 8205) {
                return true;
            }
            return codePoint == 8204;
        }
        if (type == 15) {
            return false;
        }
        if (type == 13 || type == 14 || type == 12) {
            return codePoint == 32 || codePoint == 160;
        }
        return true;
    }

    private static boolean isControlOrSpecialBlock(Character.UnicodeBlock block) {
        return block == Character.UnicodeBlock.SPECIALS || block == Character.UnicodeBlock.CONTROL_PICTURES || block == Character.UnicodeBlock.PRIVATE_USE_AREA || block == Character.UnicodeBlock.HIGH_SURROGATES || block == Character.UnicodeBlock.HIGH_PRIVATE_USE_SURROGATES || block == Character.UnicodeBlock.LOW_SURROGATES || block == Character.UnicodeBlock.SUPPLEMENTARY_PRIVATE_USE_AREA_A || block == Character.UnicodeBlock.SUPPLEMENTARY_PRIVATE_USE_AREA_B;
    }

    private static boolean isCommonWhitespace(int codePoint) {
        return codePoint == 32 || codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint == 160;
    }

    public static String filterNonHumanFriendly(String str, String replacement) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return StringBuilderUtils.buildString(str, replacement, (_str, _replacement, sb) -> {
            int codePoint;
            for (int i = 0; i < _str.length(); i += Character.charCount(codePoint)) {
                codePoint = _str.codePointAt(i);
                if (CharsetUtils.isHumanFriendly(codePoint)) {
                    sb.appendCodePoint(codePoint);
                    continue;
                }
                if (_replacement == null) continue;
                sb.append((String)_replacement);
            }
        });
    }

    public static String filterNonHumanFriendly(String str) {
        return CharsetUtils.filterNonHumanFriendly(str, null);
    }
}

