/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace.data;

import com.google.common.collect.Maps;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.core.trace.data.SpanEventDataInfo;
import org.jetlinks.core.utils.RecyclerUtils;
import org.jetlinks.core.utils.SerializeUtils;

public class SpanDataInfo
implements Externalizable {
    private static final long serialVersionUID = -1L;
    private String app;
    private String name;
    private String traceId;
    private String spanId;
    private String parentSpanId;
    private long startWithNanos;
    private long endWithNanos;
    private Map<String, Object> attributes;
    private List<SpanEventDataInfo> events;
    private transient List<? extends SpanDataInfo> children;

    public static SpanDataInfo of(SpanData data) {
        return new SpanDataInfo().with(data);
    }

    public SpanDataInfo with(SpanData data) {
        List eventData;
        this.app = data.getInstrumentationScopeInfo().getName();
        this.name = data.getName();
        this.traceId = data.getTraceId();
        this.spanId = data.getSpanId();
        this.parentSpanId = data.getParentSpanId();
        this.startWithNanos = data.getStartEpochNanos();
        this.endWithNanos = data.getEndEpochNanos();
        Attributes attr = data.getAttributes();
        if (!attr.isEmpty()) {
            this.attributes = Maps.newHashMapWithExpectedSize((int)attr.size());
            attr.forEach((k, v) -> {
                if (v instanceof Supplier) {
                    v = ((Supplier)v).get();
                }
                this.attributes.put(k.getKey(), v);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(eventData = data.getEvents()))) {
            this.events = new ArrayList<SpanEventDataInfo>();
            for (EventData eventDatum : eventData) {
                this.events.add(SpanEventDataInfo.of(eventDatum));
            }
        }
        return this;
    }

    public Optional<SpanEventDataInfo> getEvent(String name) {
        if (this.events == null) {
            return Optional.empty();
        }
        for (SpanEventDataInfo eventInfo : this.events) {
            if (!Objects.equals(name, eventInfo.getName())) continue;
            return Optional.of(eventInfo);
        }
        return Optional.empty();
    }

    public <T> Optional<T> getAttribute(String key) {
        if (this.attributes == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.attributes.get(key));
    }

    public <T> Optional<T> getAttribute(AttributeKey<T> key) {
        return this.getAttribute(key.getKey());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(2);
        out.writeUTF(this.app);
        out.writeUTF(this.name);
        out.writeUTF(this.traceId);
        out.writeUTF(this.spanId);
        out.writeUTF(this.parentSpanId);
        out.writeLong(this.startWithNanos);
        out.writeLong(this.endWithNanos);
        SerializeUtils.writeKeyValue(this.attributes, out);
        if (this.events == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.events.size());
            for (SpanEventDataInfo event : this.events) {
                event.writeExternal(out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readUnsignedByte();
        this.app = RecyclerUtils.intern(in.readUTF());
        this.name = RecyclerUtils.intern(in.readUTF());
        this.traceId = in.readUTF();
        this.spanId = in.readUTF();
        this.parentSpanId = in.readUTF();
        this.startWithNanos = in.readLong();
        this.endWithNanos = in.readLong();
        this.attributes = SerializeUtils.readMap(in, e -> RecyclerUtils.intern(String.valueOf(e)), Function.identity(), Maps::newHashMapWithExpectedSize);
        int eventSize = in.readInt();
        if (eventSize > 0) {
            this.events = new ArrayList<SpanEventDataInfo>(eventSize);
            for (int i = 0; i < eventSize; ++i) {
                SpanEventDataInfo dataInfo = new SpanEventDataInfo();
                dataInfo.readExternal(in);
                this.events.add(dataInfo);
            }
        }
    }

    public StringBuilder toString(StringBuilder builder) {
        return this.toString(builder, "", true);
    }

    public StringBuilder toString(StringBuilder builder, String prefix, boolean isLast) {
        builder.append(prefix);
        if (!prefix.isEmpty()) {
            builder.append(isLast ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ");
        }
        builder.append("\ud83d\udd0d [").append(this.app != null ? this.app : "unknown").append("] ").append(this.name != null ? this.name : "unknown");
        long durationMs = (this.endWithNanos - this.startWithNanos) / 1000000L;
        builder.append(" (").append(durationMs).append("ms)").append("\n");
        String childPrefix = prefix + (isLast ? "    " : "\u2502   ");
        if (this.attributes != null && !this.attributes.isEmpty()) {
            builder.append(childPrefix).append("\u251c\u2500\u2500 \ud83c\udff7\ufe0f Attributes:\n");
            String attrPrefix = childPrefix + "\u2502   ";
            int attrIndex = 0;
            int attrCount = this.attributes.size();
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                boolean isLastAttr = attrIndex == attrCount - 1;
                builder.append(attrPrefix).append(isLastAttr ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ").append(entry.getKey()).append(": ");
                this.formatMultiLineValue(String.valueOf(entry.getValue()), attrPrefix + (isLastAttr ? "    " : "\u2502   "), entry.getKey(), builder);
                builder.append("\n");
                ++attrIndex;
            }
        }
        if (this.events != null && !this.events.isEmpty()) {
            boolean hasAttributes = this.attributes != null && !this.attributes.isEmpty();
            boolean hasChildren = this.children != null && !this.children.isEmpty();
            String eventBranch = hasChildren ? "\u251c\u2500\u2500 " : "\u2514\u2500\u2500 ";
            builder.append(childPrefix).append(eventBranch).append("\u26a0\ufe0f Events:\n");
            String eventPrefix = childPrefix + (hasChildren ? "\u2502   " : "    ");
            for (int i = 0; i < this.events.size(); ++i) {
                SpanEventDataInfo event = this.events.get(i);
                boolean isLastEvent = i == this.events.size() - 1;
                String eventEmoji = this.getEventEmoji(event.getName());
                builder.append(eventPrefix).append(isLastEvent ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ").append(eventEmoji).append(" ").append(event.getName());
                long relativeTimeMs = (event.getTimeNanos() - this.startWithNanos) / 1000000L;
                builder.append(" (at ").append(relativeTimeMs).append("ms)").append("\n");
                if (event.getAttributes() == null || event.getAttributes().isEmpty()) continue;
                String eventAttrPrefix = eventPrefix + (isLastEvent ? "    " : "\u2502   ");
                int attrIndex = 0;
                int attrCount = event.getAttributes().size();
                for (Map.Entry<String, Object> attr : event.getAttributes().entrySet()) {
                    boolean isLastEventAttr = attrIndex == attrCount - 1;
                    builder.append(eventAttrPrefix).append(isLastEventAttr ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ").append(attr.getKey()).append(": ");
                    this.formatMultiLineValue(String.valueOf(attr.getValue()), eventAttrPrefix + (isLastEventAttr ? "    " : "\u2502   "), attr.getKey(), builder);
                    builder.append("\n");
                    ++attrIndex;
                }
            }
        }
        if (this.children != null && !this.children.isEmpty()) {
            for (int i = 0; i < this.children.size(); ++i) {
                SpanDataInfo child = this.children.get(i);
                boolean isLastChild = i == this.children.size() - 1;
                child.toString(builder, childPrefix, isLastChild);
            }
        }
        return builder;
    }

    private void formatMultiLineValue(String value, String prefix, String key, StringBuilder builder) {
        if (value == null) {
            builder.append("null");
            return;
        }
        String[] lines = value.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                builder.append("\n").append(prefix);
                int alignLength = key.length() + 2;
                for (int j = 0; j < alignLength; ++j) {
                    builder.append(" ");
                }
            }
            builder.append(lines[i]);
        }
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    private String getEventEmoji(String eventName) {
        if (eventName == null) {
            return "\ud83d\udcdd";
        }
        String lowerName = eventName.toLowerCase();
        if (lowerName.contains("error") || lowerName.contains("fail") || lowerName.contains("exception")) {
            return "\u274c";
        }
        if (lowerName.contains("warn") || lowerName.contains("timeout") || lowerName.contains("retry")) {
            return "\u26a0\ufe0f";
        }
        if (lowerName.contains("start") || lowerName.contains("begin") || lowerName.contains("init")) {
            return "\ud83d\ude80";
        }
        if (lowerName.contains("finish") || lowerName.contains("complete") || lowerName.contains("end") || lowerName.contains("success")) {
            return "\u2705";
        }
        if (lowerName.contains("sql") || lowerName.contains("query") || lowerName.contains("database") || lowerName.contains("db")) {
            return "\ud83d\uddc4\ufe0f";
        }
        if (lowerName.contains("request") || lowerName.contains("response") || lowerName.contains("http") || lowerName.contains("api")) {
            return "\ud83c\udf10";
        }
        if (lowerName.contains("auth") || lowerName.contains("login") || lowerName.contains("logout") || lowerName.contains("permission")) {
            return "\ud83d\udd10";
        }
        if (lowerName.contains("cache") || lowerName.contains("redis") || lowerName.contains("memory")) {
            return "\ud83d\udcbe";
        }
        if (lowerName.contains("log") || lowerName.contains("audit") || lowerName.contains("record")) {
            return "\ud83d\udccb";
        }
        if (lowerName.contains("business") || lowerName.contains("logic") || lowerName.contains("process") || lowerName.contains("execute")) {
            return "\u2699\ufe0f";
        }
        return "\ud83d\udcdd";
    }

    public String getApp() {
        return this.app;
    }

    public String getName() {
        return this.name;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public String getParentSpanId() {
        return this.parentSpanId;
    }

    public long getStartWithNanos() {
        return this.startWithNanos;
    }

    public long getEndWithNanos() {
        return this.endWithNanos;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public List<SpanEventDataInfo> getEvents() {
        return this.events;
    }

    public List<? extends SpanDataInfo> getChildren() {
        return this.children;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setSpanId(String spanId) {
        this.spanId = spanId;
    }

    public void setParentSpanId(String parentSpanId) {
        this.parentSpanId = parentSpanId;
    }

    public void setStartWithNanos(long startWithNanos) {
        this.startWithNanos = startWithNanos;
    }

    public void setEndWithNanos(long endWithNanos) {
        this.endWithNanos = endWithNanos;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void setEvents(List<SpanEventDataInfo> events) {
        this.events = events;
    }

    public void setChildren(List<? extends SpanDataInfo> children) {
        this.children = children;
    }
}

