/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import org.jetlinks.core.lang.SharedPathString;
import org.jetlinks.core.utils.StringBuilderUtils;

public interface ProtocolTracer {

    public static interface SpanName {
        public static final SharedPathString allOperations = SharedPathString.of("/protocol/*/*");

        public static String operation(String protocolId, String operation) {
            return StringBuilderUtils.buildString(protocolId, operation, (str, opt, stringBuilder) -> stringBuilder.append("/protocol/").append((String)str).append("/").append((String)opt));
        }

        public static String encode(String protocolId) {
            return SpanName.operation(protocolId, "encode");
        }

        public static CharSequence encode0(String protocolId) {
            return allOperations.replace(2, protocolId, 3, "encode");
        }

        public static String decode(String protocolId) {
            return SpanName.operation(protocolId, "decode");
        }

        public static CharSequence decode0(String protocolId) {
            return allOperations.replace(2, protocolId, 3, "decode");
        }

        public static String install(String protocolId) {
            return SpanName.operation(protocolId, "install");
        }
    }
}

