/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import org.jetlinks.core.trace.AbstractReactiveTracerBuilder;
import org.jetlinks.core.trace.MonoTracer;
import org.jetlinks.core.trace.ReactiveSpan;
import org.jetlinks.core.trace.TraceHolder;
import org.jetlinks.core.trace.TraceMono;
import reactor.core.publisher.Mono;
import reactor.function.Consumer3;
import reactor.util.context.ContextView;

class MonoTracerBuilder<T>
extends AbstractReactiveTracerBuilder<MonoTracer<T>, T>
implements MonoTracer<T> {
    private boolean fastSubscribe;

    @Override
    public MonoTracer<T> build() {
        return this;
    }

    @Override
    public Mono<T> apply(Mono<T> source) {
        return new TraceMono<T>(source, this.spanName, TraceHolder.telemetry().getTracer(this.scopeName), this.onNext, (Consumer3<ContextView, ReactiveSpan, Long>)this.onComplete, this.onSubscription, this.onError, this.fastSubscribe, this.defaultContext);
    }

    private MonoTracerBuilder(boolean fastSubscribe) {
        this.fastSubscribe = fastSubscribe;
    }

    public static <T> MonoTracerBuilder<T> create(boolean fastSubscribe) {
        return new MonoTracerBuilder<T>(fastSubscribe);
    }

    public MonoTracerBuilder() {
    }
}

