/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.trace;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.lang.SeparatedCharSequence;
import org.jetlinks.core.lang.SharedPathString;
import org.jetlinks.core.trace.data.SpanDataInfo;
import org.jetlinks.core.utils.TopicUtils;
import reactor.core.publisher.Mono;

public class EventBusSpanExporter
implements SpanExporter {
    private final EventBus eventBus;

    public CompletableResultCode export(Collection<SpanData> spans) {
        for (SpanData span : spans) {
            this.doPublish(span).subscribe();
        }
        return CompletableResultCode.ofSuccess();
    }

    Mono<Long> doPublish(SpanData data) {
        SeparatedCharSequence topic = SharedPathString.of(new String[]{"", "trace", data.getInstrumentationScopeInfo().getName()}).append(SharedPathString.of(TopicUtils.split(data.getName(), true, false)));
        return this.eventBus.publish((CharSequence)topic, () -> SpanDataInfo.of(data));
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }

    private EventBusSpanExporter(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public static EventBusSpanExporter create(EventBus eventBus) {
        return new EventBusSpanExporter(eventBus);
    }
}

