/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.things.rpc;

import java.util.Map;
import java.util.function.Consumer;
import org.jetlinks.core.message.HeaderKey;
import org.jetlinks.core.message.Headers;
import org.jetlinks.core.message.RepayableThingMessage;
import org.jetlinks.core.message.ThingMessageReply;
import reactor.core.publisher.Mono;

public interface ThingRpcSpec<Self extends ThingRpcSpec<Self, Message, Reply>, Message extends RepayableThingMessage<Reply>, Reply extends ThingMessageReply> {
    default public Self timeout(long timeoutMs) {
        return this.custom(msg -> msg.addHeader(Headers.timeout, timeoutMs));
    }

    default public Self messageId(String messageId) {
        return this.custom(msg -> msg.messageId(messageId));
    }

    default public Self async(boolean async) {
        return this.custom(msg -> msg.addHeader(Headers.async, async));
    }

    default public <T> Self header(HeaderKey<T> header, T value) {
        return this.custom(msg -> msg.addHeader(header, value));
    }

    default public Self header(String header, Object value) {
        return this.custom(msg -> msg.addHeader(header, value));
    }

    default public Self headers(Map<String, Object> headers) {
        return this.custom(msg -> headers.forEach(msg::addHeader));
    }

    public Self mapErrorToReply(boolean var1);

    public Self custom(Consumer<Message> var1);

    public Mono<Reply> execute();

    public Reply executeBlocking();
}

