/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.things.rpc;

import java.time.Duration;
import java.util.function.Consumer;
import org.jetlinks.core.message.Headers;
import org.jetlinks.core.message.RepayableThingMessage;
import org.jetlinks.core.message.ThingMessage;
import org.jetlinks.core.message.ThingMessageReply;
import org.jetlinks.core.things.ThingRpcSupport;
import org.jetlinks.core.things.rpc.ThingRpcSpec;
import org.jetlinks.core.utils.Reactors;
import reactor.core.publisher.Mono;

public class GenericThingRpcSpec<Self extends ThingRpcSpec<Self, Message, Reply>, Message extends RepayableThingMessage<Reply>, Reply extends ThingMessageReply>
implements ThingRpcSpec<Self, Message, Reply> {
    private final Mono<ThingRpcSupport> support;
    private final Message message;
    private boolean mapErrorToReply;

    @Override
    public Self mapErrorToReply(boolean mapErrorToReply) {
        this.mapErrorToReply = mapErrorToReply;
        return this.caseSelf();
    }

    @Override
    public Self custom(Consumer<Message> handler) {
        handler.accept(this.message);
        return this.caseSelf();
    }

    @Override
    public Mono<Reply> execute() {
        Mono executor = this.support.flatMap(support -> support.call((ThingMessage)this.message).map(msg -> (ThingMessageReply)msg).singleOrEmpty());
        if (this.mapErrorToReply) {
            return executor.onErrorResume(err -> {
                Object reply = this.message.newReply();
                reply.error((Throwable)err);
                return Mono.just(reply);
            });
        }
        return executor;
    }

    @Override
    public Reply executeBlocking() {
        long timeout = this.message.getOrAddHeaderDefault(Headers.timeout);
        return (Reply)((ThingMessageReply)Reactors.await(this.execute(), Duration.ofMillis(timeout)));
    }

    protected Self caseSelf() {
        return (Self)this;
    }

    public GenericThingRpcSpec(Mono<ThingRpcSupport> support, Message message) {
        this.support = support;
        this.message = message;
    }
}

