/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.server.session;

import io.netty.util.ReferenceCountUtil;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nullable;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.exception.DeviceOperationException;
import org.jetlinks.core.message.Headers;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.ToDeviceMessageContext;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.server.session.DeviceSession;
import org.jetlinks.core.server.session.PersistentSession;
import org.jetlinks.core.server.session.ReplaceableDeviceSession;
import org.jetlinks.core.utils.Reactors;
import reactor.core.publisher.Mono;

public class KeepOnlineSession
implements DeviceSession,
ReplaceableDeviceSession,
PersistentSession {
    DeviceSession parent;
    private long lastKeepAliveTime = System.currentTimeMillis();
    private final long connectTime = System.currentTimeMillis();
    private boolean ignoreParent = Headers.keepOnlineIgnoreParent.getDefaultValue();
    private long keepAliveTimeOutMs;

    public KeepOnlineSession(DeviceSession parent, Duration keepAliveTimeOut) {
        this.parent = parent;
        this.setKeepAliveTimeout(keepAliveTimeOut);
    }

    @Override
    public String getId() {
        return this.parent.getId();
    }

    @Override
    public String getDeviceId() {
        return this.parent.getDeviceId();
    }

    @Override
    @Nullable
    public DeviceOperator getOperator() {
        return this.parent.getOperator();
    }

    @Override
    public long lastPingTime() {
        return this.lastKeepAliveTime;
    }

    @Override
    public long connectTime() {
        return this.connectTime;
    }

    @Override
    public Mono<Boolean> send(EncodedMessage encodedMessage) {
        return Mono.defer(() -> {
            if (this.parent.isAlive()) {
                return this.parent.send(encodedMessage);
            }
            ReferenceCountUtil.safeRelease((Object)encodedMessage.getPayload());
            return Mono.error((Throwable)new DeviceOperationException.NoStackTrace(ErrorCode.CONNECTION_LOST));
        });
    }

    @Override
    public Transport getTransport() {
        return this.parent.getTransport();
    }

    @Override
    public void close() {
        if (!this.ignoreParent) {
            this.parent.close();
        }
    }

    @Override
    public void ping() {
        this.lastKeepAliveTime = System.currentTimeMillis();
        this.parent.keepAlive();
    }

    @Override
    public void keepAlive(long time) {
        this.lastKeepAliveTime = time;
        this.parent.keepAlive(time);
    }

    @Override
    public boolean isAlive() {
        if (this.aliveByKeepAlive()) {
            return true;
        }
        if (this.ignoreParent) {
            return false;
        }
        return this.parent.isAlive();
    }

    private boolean aliveByKeepAlive() {
        return this.keepAliveTimeOutMs <= 0L || System.currentTimeMillis() - this.lastKeepAliveTime < this.keepAliveTimeOutMs;
    }

    @Override
    public void onClose(Runnable call) {
        this.parent.onClose(call);
    }

    @Override
    public Optional<String> getServerId() {
        return this.parent.getServerId();
    }

    @Override
    public Optional<InetSocketAddress> getClientAddress() {
        return this.parent.getClientAddress();
    }

    @Override
    public void setKeepAliveTimeout(Duration timeout) {
        this.keepAliveTimeOutMs = timeout.toMillis();
        this.parent.setKeepAliveTimeout(timeout);
    }

    @Override
    public Duration getKeepAliveTimeout() {
        return Duration.ofMillis(this.keepAliveTimeOutMs);
    }

    @Override
    public boolean isWrapFrom(Class<?> type) {
        return type.isInstance(this) || this.parent.isWrapFrom(type);
    }

    @Override
    public <T extends DeviceSession> T unwrap(Class<T> type) {
        return (T)(type.isInstance(this) ? (DeviceSession)type.cast(this) : this.parent.unwrap(type));
    }

    @Override
    public void replaceWith(DeviceSession session) {
        this.parent = session;
    }

    @Override
    public String getProvider() {
        return "keep_online";
    }

    @Override
    public Mono<Boolean> isAliveAsync() {
        if (this.aliveByKeepAlive()) {
            return Reactors.ALWAYS_TRUE;
        }
        if (this.ignoreParent) {
            return Reactors.ALWAYS_FALSE;
        }
        return this.parent.isAliveAsync();
    }

    @Override
    public boolean isChanged(DeviceSession another) {
        return this.parent.isChanged(another);
    }

    public String toString() {
        return "keepOnline[" + this.keepAliveTimeOutMs + "ms]:" + this.parent;
    }

    @Override
    public Mono<Boolean> send(ToDeviceMessageContext context) {
        return this.parent.send(context);
    }

    public DeviceSession getParent() {
        return this.parent;
    }

    void setLastKeepAliveTime(long lastKeepAliveTime) {
        this.lastKeepAliveTime = lastKeepAliveTime;
    }

    public void setIgnoreParent(boolean ignoreParent) {
        this.ignoreParent = ignoreParent;
    }

    public boolean isIgnoreParent() {
        return this.ignoreParent;
    }
}

