/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.server.session;

import io.opentelemetry.api.common.AttributeKey;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.ToDeviceMessageContext;
import org.jetlinks.core.message.codec.TraceDeviceSession;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.trace.DeviceTracer;
import org.jetlinks.core.trace.FluxTracer;
import org.jetlinks.core.trace.TraceHolder;
import org.jetlinks.core.utils.Reactors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface DeviceSession {
    public String getId();

    public String getDeviceId();

    @Nullable
    public DeviceOperator getOperator();

    public long lastPingTime();

    public long connectTime();

    public Mono<Boolean> send(EncodedMessage var1);

    @Nonnull
    @Deprecated
    default public <V> Mono<V> execute(@Nonnull Command<V> command) {
        return Mono.error(UnsupportedOperationException::new);
    }

    public Transport getTransport();

    public void close();

    @Deprecated
    public void ping();

    public boolean isAlive();

    public void onClose(Runnable var1);

    @Deprecated
    default public Optional<String> getServerId() {
        return Optional.empty();
    }

    default public Optional<InetSocketAddress> getClientAddress() {
        return Optional.empty();
    }

    default public void keepAlive() {
        this.ping();
    }

    default public void keepAlive(long time) {
        this.keepAlive();
    }

    default public void setKeepAliveTimeout(Duration timeout) {
    }

    default public Duration getKeepAliveTimeout() {
        return Duration.ZERO;
    }

    default public boolean isWrapFrom(Class<?> type) {
        return type.isInstance(this);
    }

    default public <T extends DeviceSession> T unwrap(Class<T> type) {
        return (T)((DeviceSession)type.cast(this));
    }

    default public Mono<Boolean> isAliveAsync() {
        return Mono.fromSupplier(this::isAlive);
    }

    default public boolean isChanged(DeviceSession another) {
        return !this.equals(another);
    }

    default public Mono<Boolean> send(ToDeviceMessageContext context) {
        DeviceOperator device = context.getDevice();
        if (device == null) {
            return Reactors.ALWAYS_FALSE;
        }
        return (Mono)((Flux)device.getProtocol().flatMap(protocol -> protocol.getMessageCodec(this.getTransport())).flatMapMany(codec -> codec.encode(context)).as(FluxTracer.create((CharSequence)DeviceTracer.SpanName.encode0(device.getDeviceId()), (span, msg) -> span.setAttribute((AttributeKey)DeviceTracer.SpanKey.message, (Object)msg.toString())))).as(context::sendToDevice);
    }

    public static DeviceSession trace(DeviceSession target) {
        if (TraceHolder.isDisabled()) {
            return target;
        }
        return TraceDeviceSession.of(target);
    }
}

