/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.server.session;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.ToDeviceMessageContext;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.server.session.DeviceSession;
import org.jetlinks.core.server.session.ReplaceableDeviceSession;
import org.jetlinks.core.utils.Reactors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ChildrenDeviceSession
implements DeviceSession,
ReplaceableDeviceSession {
    private static final Logger log = LoggerFactory.getLogger(ChildrenDeviceSession.class);
    private final String id;
    private final String deviceId;
    private DeviceSession parent;
    private final DeviceOperator operator;
    private List<Runnable> closeListener;
    private final long connectTime = System.currentTimeMillis();
    private long lastKeepAliveTime;
    private long keepAliveTimeOutMs = -1L;
    private BiConsumer<DeviceSession, DeviceSession> parentChanged;

    public ChildrenDeviceSession(String deviceId, DeviceSession parent, DeviceOperator operator) {
        this.id = deviceId;
        this.parent = parent;
        this.operator = operator;
        this.deviceId = deviceId;
        this.lastKeepAliveTime = parent.lastPingTime();
    }

    public DeviceOperator getParentDevice() {
        return this.parent.getOperator();
    }

    @Override
    public long lastPingTime() {
        return this.lastKeepAliveTime;
    }

    @Override
    public long connectTime() {
        return this.connectTime;
    }

    @Override
    public Mono<Boolean> send(EncodedMessage encodedMessage) {
        log.info("send child device[{}:{}] message", (Object)this.parent.getDeviceId(), (Object)this.deviceId);
        return this.parent.send(encodedMessage);
    }

    @Override
    public Transport getTransport() {
        return this.parent.getTransport();
    }

    @Override
    public void close() {
        if (null != this.closeListener) {
            this.closeListener.forEach(Runnable::run);
        }
    }

    @Override
    public void ping() {
        this.parent.ping();
        this.lastKeepAliveTime = System.currentTimeMillis();
    }

    @Override
    public void keepAlive(long time) {
        this.parent.keepAlive(time);
        this.lastKeepAliveTime = time;
    }

    @Override
    public void keepAlive() {
        this.parent.keepAlive();
        this.lastKeepAliveTime = System.currentTimeMillis();
    }

    private boolean aliveByKeepAlive() {
        return this.keepAliveTimeOutMs <= 0L || System.currentTimeMillis() - this.lastKeepAliveTime < this.keepAliveTimeOutMs;
    }

    @Override
    public synchronized void onClose(Runnable call) {
        if (this.closeListener == null) {
            this.closeListener = new CopyOnWriteArrayList<Runnable>();
        }
        this.closeListener.add(call);
    }

    @Override
    public Optional<String> getServerId() {
        return this.parent.getServerId();
    }

    @Override
    public Optional<InetSocketAddress> getClientAddress() {
        return this.parent.getClientAddress();
    }

    @Override
    public void setKeepAliveTimeout(Duration timeout) {
        this.keepAliveTimeOutMs = timeout.toMillis();
    }

    @Override
    public Duration getKeepAliveTimeout() {
        return Duration.ofMillis(this.keepAliveTimeOutMs);
    }

    @Override
    public boolean isWrapFrom(Class<?> type) {
        return type.isInstance(this) || this.parent.isWrapFrom(type);
    }

    @Override
    public <T extends DeviceSession> T unwrap(Class<T> type) {
        return (T)(type.isInstance(this) ? (DeviceSession)type.cast(this) : this.parent.unwrap(type));
    }

    @Override
    public boolean isAlive() {
        if (this.keepAliveTimeOutMs > 0L && this.aliveByKeepAlive()) {
            return true;
        }
        return this.parent.isAlive();
    }

    @Override
    public Mono<Boolean> isAliveAsync() {
        if (this.keepAliveTimeOutMs > 0L && this.aliveByKeepAlive()) {
            return Reactors.ALWAYS_TRUE;
        }
        return this.parent.isAliveAsync();
    }

    @Override
    public boolean isChanged(DeviceSession another) {
        return this.parent.isChanged(another);
    }

    public String toString() {
        return "children device[" + this.deviceId + "] in " + this.parent;
    }

    public synchronized void doOnParentChanged(BiConsumer<DeviceSession, DeviceSession> consumer) {
        this.parentChanged = consumer;
    }

    @Override
    public void replaceWith(DeviceSession session) {
        if (session == this || Objects.equals(session.getDeviceId(), this.getDeviceId())) {
            throw new IllegalStateException("can not replace with self");
        }
        DeviceSession old = this.parent;
        this.parent = session.isWrapFrom(ChildrenDeviceSession.class) ? session.unwrap(ChildrenDeviceSession.class).getParent() : session;
        if (this.parentChanged != null) {
            this.parentChanged.accept(old, this.parent);
        }
    }

    @Override
    public Mono<Boolean> send(ToDeviceMessageContext context) {
        return this.parent.send(context);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    public DeviceSession getParent() {
        return this.parent;
    }

    @Override
    public DeviceOperator getOperator() {
        return this.operator;
    }
}

