/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.monitor.logger;

import org.jetlinks.core.monitor.logger.Logger;
import org.slf4j.event.Level;

public interface Slf4jLoggerAdapter
extends Logger {
    public org.slf4j.Logger getLogger();

    @Override
    default public boolean isEnabled(Level level) {
        switch (level) {
            case TRACE: {
                return this.getLogger().isTraceEnabled();
            }
            case DEBUG: {
                return this.getLogger().isDebugEnabled();
            }
            case INFO: {
                return this.getLogger().isInfoEnabled();
            }
            case WARN: {
                return this.getLogger().isWarnEnabled();
            }
            case ERROR: {
                return this.getLogger().isErrorEnabled();
            }
        }
        return false;
    }

    @Override
    default public void log(Level level, String message, Object ... args) {
        switch (level) {
            case TRACE: {
                this.getLogger().trace(message, args);
                return;
            }
            case DEBUG: {
                this.getLogger().debug(message, args);
                return;
            }
            case INFO: {
                this.getLogger().info(message, args);
                return;
            }
            case WARN: {
                this.getLogger().warn(message, args);
                return;
            }
            case ERROR: {
                this.getLogger().error(message, args);
            }
        }
    }
}

