/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.validator;

import java.util.regex.Pattern;
import org.jetlinks.core.metadata.validator.AbstractValidator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RegexValidator
extends AbstractValidator {
    private final Pattern pattern;

    public RegexValidator(String regex, String errorMessage) {
        super(errorMessage);
        Assert.isTrue((boolean)StringUtils.hasText((String)regex), (String)"regex cannot be empty");
        this.pattern = Pattern.compile(regex);
    }

    @Override
    protected String defaultErrorMessage() {
        return "message.regex_validator_fail";
    }

    @Override
    protected boolean doValidate(Object value) {
        return this.pattern.matcher(String.valueOf(value)).matches();
    }
}

