/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.validator;

import java.util.Objects;
import org.jetlinks.core.metadata.ValidateResult;
import org.jetlinks.core.metadata.validator.Validator;
import org.springframework.util.StringUtils;

public abstract class AbstractValidator
implements Validator {
    private final String errorMessage;

    protected AbstractValidator(String errorMessage) {
        this.errorMessage = StringUtils.hasText((String)errorMessage) ? errorMessage : this.defaultErrorMessage();
    }

    protected abstract String defaultErrorMessage();

    @Override
    public ValidateResult validate(Object value) {
        if (Objects.nonNull(value)) {
            if (!this.doValidate(value)) {
                return ValidateResult.fail(this.errorMessage);
            }
            return ValidateResult.success(value);
        }
        return ValidateResult.fail(this.errorMessage);
    }

    protected abstract boolean doValidate(Object var1);
}

