/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.unit;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetlinks.core.metadata.unit.JsonValueUnit;
import org.jetlinks.core.metadata.unit.SymbolValueUnit;
import org.jetlinks.core.metadata.unit.UnifyUnit;
import org.jetlinks.core.metadata.unit.ValueUnit;
import org.jetlinks.core.metadata.unit.ValueUnitSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;

public class ValueUnits {
    private static final Logger log = LoggerFactory.getLogger(ValueUnits.class);
    private static final List<ValueUnitSupplier> suppliers = new CopyOnWriteArrayList<ValueUnitSupplier>();

    private ValueUnits() {
    }

    public static Disposable register(ValueUnitSupplier supplier) {
        suppliers.add(supplier);
        return () -> suppliers.remove(supplier);
    }

    public static Optional<ValueUnit> lookup(String id) {
        for (ValueUnitSupplier supplier : suppliers) {
            try {
                Optional<ValueUnit> unit = supplier.getById(id);
                if (!unit.isPresent()) continue;
                return unit;
            }
            catch (Error ignore) {
                suppliers.remove(supplier);
            }
        }
        if (id.startsWith("{")) {
            return Optional.ofNullable(JsonValueUnit.of(id));
        }
        return Optional.of(SymbolValueUnit.of(id));
    }

    public static List<ValueUnit> getAllUnit() {
        return suppliers.stream().flatMap(supplier -> {
            try {
                return supplier.getAll().stream();
            }
            catch (Error err) {
                suppliers.remove(supplier);
                return Stream.empty();
            }
        }).collect(Collectors.toList());
    }

    static {
        ValueUnits.register(new ValueUnitSupplier(){

            @Override
            public Optional<ValueUnit> getById(String id) {
                return Optional.ofNullable(UnifyUnit.of(id));
            }

            @Override
            public List<ValueUnit> getAll() {
                return Arrays.asList(UnifyUnit.values());
            }
        });
        ServiceLoader.load(ValueUnitSupplier.class).forEach(ValueUnits::register);
    }
}

