/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Locale;
import java.util.Optional;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.ValidateResult;
import org.jetlinks.core.metadata.types.AbstractType;
import org.jetlinks.core.metadata.validator.Validator;

public class PasswordType
extends AbstractType<PasswordType>
implements DataType,
Converter<String> {
    public static final String ID = "password";
    public static final PasswordType GLOBAL = new PasswordType();
    @JsonIgnore
    private transient Validator validator;

    public PasswordType withValidator(Validator validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return LocaleUtils.resolveMessage((String)"message.metadata.type.password", (Locale)LocaleUtils.current(), (String)"\u5bc6\u7801", (Object[])new Object[0]);
    }

    @Override
    public ValidateResult validate(Object value) {
        return Optional.ofNullable(this.validator).map(validator -> validator.validate(value)).orElse(ValidateResult.success(String.valueOf(value)));
    }

    @Override
    public String format(Object value) {
        return String.valueOf(value);
    }

    @Override
    public String convert(Object value) {
        return value == null ? null : String.valueOf(value);
    }

    public Validator getValidator() {
        return this.validator;
    }

    @JsonIgnore
    public void setValidator(Validator validator) {
        this.validator = validator;
    }
}

