/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.types;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Optional;
import java.util.function.Function;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.UnitSupported;
import org.jetlinks.core.metadata.ValidateResult;
import org.jetlinks.core.metadata.types.AbstractType;
import org.jetlinks.core.metadata.unit.ValueUnit;
import org.jetlinks.core.utils.NumberUtils;

public abstract class NumberType<N extends Number>
extends AbstractType<NumberType<N>>
implements UnitSupported,
DataType,
Converter<N> {
    static boolean ORIGINAL = Boolean.parseBoolean(System.getProperty("jetlinks.type.number.convert.original", "true"));
    static boolean FORMAT_STRIP_TRAILING_ZEROS = Boolean.parseBoolean(System.getProperty("jetlinks.type.number.format.stripTrailingZeros", "false"));
    private Number max;
    private Number min;
    private ValueUnit unit;
    private RoundingMode round = this.defaultRound();
    private Integer scale;

    protected NumberType() {
    }

    public NumberType<N> scale(Integer scale) {
        this.scale = scale;
        return this;
    }

    public NumberType<N> round(RoundingMode round) {
        this.round = round;
        return this;
    }

    public Integer getScale(Integer defaultValue) {
        return this.scale == null ? defaultValue : this.scale;
    }

    public NumberType<N> unit(ValueUnit unit) {
        this.unit = unit;
        return this;
    }

    public NumberType<N> max(Number max) {
        this.max = max;
        return this;
    }

    public NumberType<N> min(Number min) {
        this.min = min;
        return this;
    }

    @Override
    public Object format(Object value) {
        String str;
        if (value == null) {
            return null;
        }
        Number val = (Number)NumberType.convertScaleNumber(value, this.getScale(this.defaultScale()), this.getRound(), Function.identity());
        if (val == null) {
            return String.valueOf(value);
        }
        if (val instanceof BigDecimal) {
            if (FORMAT_STRIP_TRAILING_ZEROS) {
                val = ((BigDecimal)val).stripTrailingZeros();
            }
            str = ((BigDecimal)val).toPlainString();
        } else {
            str = String.valueOf(val);
        }
        ValueUnit unit = this.getUnit();
        if (unit == null) {
            return String.valueOf(str);
        }
        return unit.format(str);
    }

    @Override
    public ValidateResult validate(Object value) {
        try {
            N numberValue = this.convertScaleNumber(value);
            if (numberValue == null) {
                return ValidateResult.fail(LocaleUtils.resolveMessage((String)"error.metadata.type.number.illegal_format", (String)("\u6570\u5b57\u683c\u5f0f\u9519\u8bef:" + value), (Object[])new Object[]{value}));
            }
            if (this.max != null && ((Number)numberValue).doubleValue() > this.max.doubleValue()) {
                return ValidateResult.fail(LocaleUtils.resolveMessage((String)"error.metadata.type.number.out_of_max", (String)("\u8d85\u8fc7\u6700\u5927\u503c:" + this.max), (Object[])new Object[]{value}));
            }
            if (this.min != null && ((Number)numberValue).doubleValue() < this.min.doubleValue()) {
                return ValidateResult.fail(LocaleUtils.resolveMessage((String)"error.metadata.type.number.out_of_min", (String)("\u5c0f\u4e8e\u6700\u5c0f\u503c:" + this.min), (Object[])new Object[]{value}));
            }
            return ValidateResult.success(numberValue);
        }
        catch (NumberFormatException e) {
            return ValidateResult.fail(e.getMessage());
        }
    }

    public final N convertNumber(Object value) {
        if (ORIGINAL) {
            return this.convertOriginalNumber(value);
        }
        return this.convertScaleNumber(value);
    }

    public final N convertOriginalNumber(Object value) {
        return (N)NumberType.convertScaleNumber(value, null, null, this::castNumber);
    }

    public final N convertScaleNumber(Object value, Integer scale, RoundingMode mode) {
        return (N)NumberType.convertScaleNumber(value, scale, mode, this::castNumber);
    }

    public final N convertScaleNumber(Object value) {
        return this.convertScaleNumber(value, this.getScale(this.defaultScale()), this.getRound());
    }

    @Override
    public final N convert(Object value) {
        Number number;
        if (value instanceof Number && NumberUtils.isIntNumber(number = (Number)value)) {
            return this.castNumber(number);
        }
        return this.convertNumber(value);
    }

    public final long getMax(long defaultVal) {
        return Optional.ofNullable(this.getMax()).map(Number::longValue).orElse(defaultVal);
    }

    public final long getMin(long defaultVal) {
        return Optional.ofNullable(this.getMin()).map(Number::longValue).orElse(defaultVal);
    }

    public final double getMax(double defaultVal) {
        return Optional.ofNullable(this.getMax()).map(Number::doubleValue).orElse(defaultVal);
    }

    public final double getMin(double defaultVal) {
        return Optional.ofNullable(this.getMin()).map(Number::doubleValue).orElse(defaultVal);
    }

    protected abstract N castNumber(Number var1);

    protected abstract int defaultScale();

    protected RoundingMode defaultRound() {
        return RoundingMode.valueOf(System.getProperty("jetlinks.type." + this.getType() + ".round", "HALF_UP"));
    }

    public static <T> T convertScaleNumber(Object value, Integer scale, RoundingMode mode, Function<Number, T> mapper) {
        BigDecimal decimal;
        if (value instanceof Number && scale == null) {
            return mapper.apply((Number)value);
        }
        if (value instanceof String) {
            try {
                value = new BigDecimal((String)value);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (value instanceof Date) {
            value = new BigDecimal(((Date)value).getTime());
        }
        if (!(value instanceof BigDecimal)) {
            try {
                decimal = new BigDecimal(String.valueOf(value));
            }
            catch (Throwable err) {
                return null;
            }
        } else {
            decimal = (BigDecimal)value;
        }
        if (scale == null) {
            return mapper.apply(decimal);
        }
        return mapper.apply(decimal.setScale((int)scale, mode));
    }

    public Number getMax() {
        return this.max;
    }

    public Number getMin() {
        return this.min;
    }

    @Override
    public ValueUnit getUnit() {
        return this.unit;
    }

    public RoundingMode getRound() {
        return this.round;
    }

    public Integer getScale() {
        return this.scale;
    }

    public void setMax(Number max) {
        this.max = max;
    }

    public void setMin(Number min) {
        this.min = min;
    }

    @Override
    public void setUnit(ValueUnit unit) {
        this.unit = unit;
    }

    public void setRound(RoundingMode round) {
        this.round = round;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }
}

