/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.ValidateResult;
import org.jetlinks.core.metadata.types.AbstractType;

public class EnumType
extends AbstractType<EnumType>
implements DataType {
    public static final String ID = "enum";
    private volatile List<Element> elements;
    private boolean multi;
    private DataType valueType;

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return LocaleUtils.resolveMessage((String)"message.metadata.type.enum", (Locale)LocaleUtils.current(), (String)"\u679a\u4e3e", (Object[])new Object[0]);
    }

    public EnumType multi(boolean multi) {
        this.multi = multi;
        return this;
    }

    @Override
    public ValidateResult validate(Object value) {
        if (this.elements == null) {
            return ValidateResult.fail("\u503c[" + value + "]\u4e0d\u5728\u679a\u4e3e\u4e2d");
        }
        Object _value = this.multi ? this.convertMulti(value) : this.convert(value);
        if (_value == null) {
            return ValidateResult.fail("\u503c[" + value + "]\u4e0d\u5728\u679a\u4e3e\u4e2d");
        }
        return ValidateResult.success(_value);
    }

    private Object convert(Object value) {
        for (Element ele : this.elements) {
            Object actValue;
            if (!this.match(value, ele)) continue;
            Object object = actValue = String.valueOf(value).equals(ele.value) ? value : ele.value;
            if (this.valueType instanceof Converter) {
                actValue = ((Converter)((Object)this.valueType)).convert(actValue);
            }
            return actValue;
        }
        return null;
    }

    public Object convertMulti(Object value) {
        ArrayList<Object> _value = new ArrayList<Object>();
        List<Object> objects = EnumType.toArray(value);
        if (!objects.isEmpty()) {
            for (Object object : objects) {
                Object _v = this.convert(object);
                if (_v == null) continue;
                _value.add(_v);
            }
        }
        if (_value.isEmpty()) {
            return null;
        }
        return _value;
    }

    private static List<Object> toArray(Object value) {
        List<Object> values = new ArrayList<Object>();
        if (value instanceof Collection) {
            values = new ArrayList((Collection)value);
        }
        if (value instanceof String) {
            String _string = (String)value;
            values = Arrays.asList(_string.split(","));
        }
        return values;
    }

    private boolean match(Object value, Element ele) {
        if (value instanceof Map) {
            Map mapVal = (Map)value;
            return this.match(mapVal.getOrDefault("value", mapVal.get("id")), ele);
        }
        String strVal = String.valueOf(value);
        return Objects.equals(ele.value, strVal) || Objects.equals(ele.text, strVal);
    }

    @Override
    public Object format(Object value) {
        if (this.elements == null) {
            return String.valueOf(value);
        }
        if (this.multi) {
            List _format = EnumType.toArray(value).stream().map(this::format0).collect(Collectors.toList());
            if (value instanceof String) {
                return String.join((CharSequence)",", _format);
            }
            return _format;
        }
        return this.format0(value);
    }

    private String format0(Object value) {
        return this.elements.stream().filter(ele -> String.valueOf(value).equals(((Element)ele).value)).findFirst().map(Element::getText).orElse(String.valueOf(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnumType addElement(Element element) {
        if (this.elements == null) {
            EnumType enumType = this;
            synchronized (enumType) {
                if (this.elements == null) {
                    this.elements = new ArrayList<Element>();
                }
            }
        }
        this.elements.add(element);
        return this;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public DataType getValueType() {
        return this.valueType;
    }

    public void setElements(List<Element> elements) {
        this.elements = elements;
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    public void setValueType(DataType valueType) {
        this.valueType = valueType;
    }

    public static class Element {
        private String value;
        private String text;
        private String description;

        public static Element of(String value, String text) {
            return Element.of(value, text, null);
        }

        public static Element of(Map<String, String> map) {
            return Element.of(map.get("value"), map.get("text"), map.get("description"));
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("value", this.value);
            map.put("text", this.text);
            map.put("description", this.description);
            return map;
        }

        public String getValue() {
            return this.value;
        }

        public String getText() {
            return this.text;
        }

        public String getDescription() {
            return this.description;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        private Element(String value, String text, String description) {
            this.value = value;
            this.text = text;
            this.description = description;
        }

        public static Element of(String value, String text, String description) {
            return new Element(value, text, description);
        }

        public Element() {
        }
    }
}

