/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.types;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.UserType;
import org.jetlinks.core.metadata.types.ArrayType;
import org.jetlinks.core.metadata.types.BooleanType;
import org.jetlinks.core.metadata.types.ByteType;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.DoubleType;
import org.jetlinks.core.metadata.types.EnumType;
import org.jetlinks.core.metadata.types.FileType;
import org.jetlinks.core.metadata.types.FloatType;
import org.jetlinks.core.metadata.types.GeoShapeType;
import org.jetlinks.core.metadata.types.GeoType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.LongType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.PasswordType;
import org.jetlinks.core.metadata.types.ShortType;
import org.jetlinks.core.metadata.types.StringType;

public class DataTypes {
    private static final Map<String, Supplier<DataType>> supports = new ConcurrentHashMap<String, Supplier<DataType>>();

    private DataTypes() {
    }

    public static void register(String id, Supplier<DataType> supplier) {
        supports.put(id, supplier);
    }

    public static Supplier<DataType> lookup(String id) {
        if (id == null) {
            return null;
        }
        return supports.get(id);
    }

    static {
        supports.put("array", ArrayType::new);
        supports.put("boolean", BooleanType::new);
        supports.put("date", DateTimeType::new);
        supports.put("double", DoubleType::new);
        supports.put("enum", EnumType::new);
        supports.put("float", FloatType::new);
        supports.put("short", ShortType::new);
        supports.put("byte", ByteType::new);
        supports.put("int", IntType::new);
        supports.put("long", LongType::new);
        supports.put("object", ObjectType::new);
        supports.put("string", StringType::new);
        supports.put("text", StringType::new);
        supports.put("geoPoint", GeoType::new);
        supports.put("file", FileType::new);
        supports.put("password", PasswordType::new);
        supports.put("geoShape", GeoShapeType::new);
        supports.put("user", UserType::new);
    }
}

