/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata.types;

import java.util.Locale;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.FormatSupport;
import org.jetlinks.core.metadata.ValidateResult;
import org.jetlinks.core.metadata.types.AbstractType;

public class BooleanType
extends AbstractType<BooleanType>
implements DataType,
FormatSupport,
Converter<Boolean> {
    public static final String ID = "boolean";
    public static final BooleanType GLOBAL = new BooleanType();
    private String trueText = "\u662f";
    private String falseText = "\u5426";
    private String trueValue = "true";
    private String falseValue = "false";

    public BooleanType trueText(String trueText) {
        this.trueText = trueText;
        return this;
    }

    public BooleanType falseText(String falseText) {
        this.falseText = falseText;
        return this;
    }

    public BooleanType trueValue(String trueValue) {
        this.trueValue = trueValue;
        return this;
    }

    public BooleanType falseValue(String falseValue) {
        this.falseValue = falseValue;
        return this;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getName() {
        return LocaleUtils.resolveMessage((String)"message.metadata.type.boolean", (Locale)LocaleUtils.current(), (String)"\u5e03\u5c14\u503c", (Object[])new Object[0]);
    }

    @Override
    public Boolean convert(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String stringVal = String.valueOf(value).trim();
        if (stringVal.equals(this.trueValue) || stringVal.equals(this.trueText)) {
            return true;
        }
        if (stringVal.equals(this.falseValue) || stringVal.equals(this.falseText)) {
            return false;
        }
        return stringVal.equals("1") || stringVal.equals("true") || stringVal.equals("y") || stringVal.equals("yes") || stringVal.equals("ok") || stringVal.equals("\u662f") || stringVal.equals("\u6b63\u5e38");
    }

    @Override
    public ValidateResult validate(Object value) {
        Boolean trueOrFalse = this.convert(value);
        return trueOrFalse == null ? ValidateResult.fail("\u4e0d\u652f\u6301\u7684\u503c:" + value) : ValidateResult.success(trueOrFalse);
    }

    @Override
    public String format(Object value) {
        Boolean trueOrFalse = this.convert(value);
        if (Boolean.TRUE.equals(trueOrFalse)) {
            return this.trueText;
        }
        if (Boolean.FALSE.equals(trueOrFalse)) {
            return this.falseText;
        }
        return "\u672a\u77e5:" + value;
    }

    public String getTrueText() {
        return this.trueText;
    }

    public String getFalseText() {
        return this.falseText;
    }

    public String getTrueValue() {
        return this.trueValue;
    }

    public String getFalseValue() {
        return this.falseValue;
    }

    public void setTrueText(String trueText) {
        this.trueText = trueText;
    }

    public void setFalseText(String falseText) {
        this.falseText = falseText;
    }

    public void setTrueValue(String trueValue) {
        this.trueValue = trueValue;
    }

    public void setFalseValue(String falseValue) {
        this.falseValue = falseValue;
    }
}

