/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata;

import java.util.function.Consumer;

public class ValidateResult {
    private boolean success;
    private Object value;
    private String errorMsg;

    public static ValidateResult success(Object value) {
        ValidateResult result = new ValidateResult();
        result.setSuccess(true);
        result.setValue(value);
        return result;
    }

    public static ValidateResult success() {
        ValidateResult result = new ValidateResult();
        result.setSuccess(true);
        return result;
    }

    public static ValidateResult fail(String message) {
        ValidateResult result = new ValidateResult();
        result.setSuccess(false);
        result.setErrorMsg(message);
        return result;
    }

    public static ValidateResult fail() {
        ValidateResult result = new ValidateResult();
        result.setSuccess(false);
        return result;
    }

    public Object assertSuccess() {
        if (!this.success) {
            throw new IllegalArgumentException(this.errorMsg);
        }
        return this.value;
    }

    public void ifFail(Consumer<ValidateResult> resultConsumer) {
        if (!this.success) {
            resultConsumer.accept(this);
        }
    }

    public static ValidateResultBuilder builder() {
        return new ValidateResultBuilder();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Object getValue() {
        return this.value;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidateResult)) {
            return false;
        }
        ValidateResult other = (ValidateResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        return !(this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidateResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        return result;
    }

    public String toString() {
        return "ValidateResult(success=" + this.isSuccess() + ", value=" + this.getValue() + ", errorMsg=" + this.getErrorMsg() + ")";
    }

    public ValidateResult(boolean success, Object value, String errorMsg) {
        this.success = success;
        this.value = value;
        this.errorMsg = errorMsg;
    }

    public ValidateResult() {
    }

    public static class ValidateResultBuilder {
        private boolean success;
        private Object value;
        private String errorMsg;

        ValidateResultBuilder() {
        }

        public ValidateResultBuilder success(boolean success) {
            this.success = success;
            return this;
        }

        public ValidateResultBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public ValidateResultBuilder errorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this;
        }

        public ValidateResult build() {
            return new ValidateResult(this.success, this.value, this.errorMsg);
        }

        public String toString() {
            return "ValidateResult.ValidateResultBuilder(success=" + this.success + ", value=" + this.value + ", errorMsg=" + this.errorMsg + ")";
        }
    }
}

