/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.metadata;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.EventMetadata;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.metadata.MergeOption;
import org.jetlinks.core.metadata.Metadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.things.ThingMetadata;
import reactor.function.Function3;

public class SimpleDeviceMetadata
implements DeviceMetadata {
    private volatile Map<String, PropertyMetadata> properties = new LinkedHashMap<String, PropertyMetadata>();
    private volatile Map<String, FunctionMetadata> functions = new LinkedHashMap<String, FunctionMetadata>();
    private volatile Map<String, EventMetadata> events = new LinkedHashMap<String, EventMetadata>();
    private volatile Map<String, PropertyMetadata> tags = new LinkedHashMap<String, PropertyMetadata>();
    private String id;
    private String name;
    private String description;
    private Map<String, Object> expands;

    public void addProperty(PropertyMetadata metadata) {
        this.properties.put(metadata.getId(), metadata);
    }

    public void addFunction(FunctionMetadata metadata) {
        this.functions.put(metadata.getId(), metadata);
    }

    public void addEvent(EventMetadata metadata) {
        this.events.put(metadata.getId(), metadata);
    }

    public void addTag(PropertyMetadata metadata) {
        this.tags.put(metadata.getId(), metadata);
    }

    @Override
    public List<PropertyMetadata> getProperties() {
        return new ArrayList<PropertyMetadata>(this.properties.values());
    }

    @Override
    public List<FunctionMetadata> getFunctions() {
        return new ArrayList<FunctionMetadata>(this.functions.values());
    }

    @Override
    public List<PropertyMetadata> getTags() {
        return new ArrayList<PropertyMetadata>(this.tags.values());
    }

    @Override
    public List<EventMetadata> getEvents() {
        return new ArrayList<EventMetadata>(this.events.values());
    }

    @Override
    public EventMetadata getEventOrNull(String id) {
        if (this.events == null) {
            return null;
        }
        return this.events.get(id);
    }

    @Override
    public PropertyMetadata getPropertyOrNull(String id) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(id);
    }

    @Override
    public FunctionMetadata getFunctionOrNull(String id) {
        if (this.functions == null) {
            return null;
        }
        return this.functions.get(id);
    }

    @Override
    public PropertyMetadata getTagOrNull(String id) {
        if (this.tags == null) {
            return null;
        }
        return this.tags.get(id);
    }

    @Override
    public Map<String, Object> getExpands() {
        return this.expands;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.properties = null;
        this.events = null;
        this.functions = null;
        this.id = json.getString("id");
        this.name = json.getString("name");
        this.description = json.getString("description");
        this.expands = json.getJSONObject("expands");
    }

    private <V extends Metadata> void doMerge(Map<String, V> map, V value, Function3<V, V, MergeOption[], V> mergeFunction, MergeOption ... options) {
        map.compute(value.getId(), (k, old) -> {
            if (old == null) {
                return value;
            }
            if (MergeOption.has(MergeOption.ignoreExists, options)) {
                return old;
            }
            return (Metadata)mergeFunction.apply(old, (Object)value, (Object)options);
        });
    }

    @Override
    public <T extends ThingMetadata> DeviceMetadata merge(T metadata, MergeOption ... options) {
        SimpleDeviceMetadata deviceMetadata = new SimpleDeviceMetadata();
        deviceMetadata.setId(metadata.getId());
        deviceMetadata.setName(metadata.getName());
        deviceMetadata.setDescription(metadata.getDescription());
        deviceMetadata.setExpands(metadata.getExpands());
        if (MergeOption.has(MergeOption.overwriteProperty, options)) {
            deviceMetadata.properties.clear();
        }
        for (PropertyMetadata propertyMetadata : metadata.getProperties()) {
            this.doMerge(deviceMetadata.properties, propertyMetadata, PropertyMetadata::merge, options);
        }
        if (MergeOption.PropertyFilter.has(options)) {
            LinkedHashMap<String, PropertyMetadata> temp = new LinkedHashMap<String, PropertyMetadata>(deviceMetadata.properties);
            deviceMetadata.properties.clear();
            for (Map.Entry entry : temp.entrySet()) {
                if (!MergeOption.PropertyFilter.doFilter((PropertyMetadata)entry.getValue(), options)) continue;
                deviceMetadata.properties.put((String)entry.getKey(), (PropertyMetadata)entry.getValue());
            }
        }
        for (FunctionMetadata functionMetadata : metadata.getFunctions()) {
            this.doMerge(deviceMetadata.functions, functionMetadata, FunctionMetadata::merge, options);
        }
        for (EventMetadata eventMetadata : metadata.getEvents()) {
            this.doMerge(deviceMetadata.events, eventMetadata, EventMetadata::merge, options);
        }
        for (PropertyMetadata propertyMetadata : metadata.getTags()) {
            this.doMerge(deviceMetadata.tags, propertyMetadata, PropertyMetadata::merge, options);
        }
        return deviceMetadata;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setExpands(Map<String, Object> expands) {
        this.expands = expands;
    }
}

